/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.ui.certificate.BFileNameFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fileNaming", type="BFileNameFormat", defaultValue="BFileNameFormat.DEFAULT"), @NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT")})
public class BImportSignedCertificateJobStep
extends BDeviceJobStep {
    public static final Property fileNaming = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BFileNameFormat.DEFAULT, null);
    public static final Property serverCertAlias = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Property password = BImportSignedCertificateJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BImportSignedCertificateJobStep.class);
    private static final Lexicon LEX = Lexicon.make((String)"provisioningNiagara");

    public BFileNameFormat getFileNaming() {
        return (BFileNameFormat)this.get(fileNaming);
    }

    public void setFileNaming(BFileNameFormat v) {
        this.set(fileNaming, (BValue)v, null);
    }

    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BImportSignedCertificateJobStep() {
    }

    public BImportSignedCertificateJobStep(BFileNameFormat fileNaming, String serverCertAlias, BPassword privateKeyPassword) {
        this.setFileNaming(fileNaming);
        this.setServerCertAlias(serverCertAlias);
        if (privateKeyPassword != null) {
            this.setPassword(privateKeyPassword);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        ICoreKeyStore keyStore;
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        BDaemonSession session = util.getDaemonSession();
        BFileNameFormat fileNaming = this.getFileNaming();
        String fileName = fileNaming == BFileNameFormat.hostname ? ((BNiagaraStation)device).getRemoteHost().getHostname() : (fileNaming == BFileNameFormat.hostId ? session.getHostProperties().getHostId() : ((BNiagaraStation)device).getStationName());
        fileName = fileName + "." + this.getServerCertAlias() + ".pem";
        File folder = new File(Sys.getStationHome(), "certImport");
        File pemFile = new File(folder, fileName);
        if (!pemFile.exists()) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.doesNotExist", pemFile.getAbsolutePath());
            details.complete(BJobState.failed);
            return;
        }
        Array certs = new Array(X509Certificate.class);
        PrivateKey pkey = null;
        try (FileInputStream fis = new FileInputStream(pemFile);
             InputStreamReader isr = new InputStreamReader(fis);
             FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
             PEMParser pr = new PEMParser((Reader)fpr);){
            Object obj = pr.readObject();
            while (obj != null) {
                if (obj instanceof X509Certificate) {
                    certs.add((Object)((X509Certificate)obj));
                } else if (obj instanceof X509CertificateHolder) {
                    X509Certificate cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                    certs.add((Object)cert);
                } else if (obj instanceof PrivateKey) {
                    if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                    pkey = (PrivateKey)obj;
                } else if (obj instanceof KeyPair) {
                    if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                    pkey = ((KeyPair)obj).getPrivate();
                } else if (obj instanceof PEMKeyPair) {
                    if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                    pkey = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).getPrivateKey(((PEMKeyPair)obj).getPrivateKeyInfo());
                } else if (obj instanceof PEMEncryptedKeyPair) {
                    if (pkey != null) throw new IOException(LEX.get("ImportSignedCertificate.failed.multipleKeys"));
                    JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    PEMDecryptorProvider decryptor = builder.build(AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()).toCharArray());
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    pkey = converter.getPrivateKey(((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor).getPrivateKeyInfo());
                } else if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
                    InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).build(AccessController.doPrivileged(() -> ((BPassword)this.getPassword()).getValue()).toCharArray());
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    pkey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo(pkcs8Prov));
                } else {
                    if (!(obj instanceof PrivateKeyInfo)) throw new IOException(LEX.get("ImportSignedCertificate.failed.unsupportedObjectType") + obj.getClass().getName());
                    JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    pkey = converter.getPrivateKey((PrivateKeyInfo)obj);
                }
                obj = pr.readObject();
            }
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.fileParse", pemFile.getAbsolutePath(), (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        BPlatCryptoManager remoteCoreCryptoManager = new BPlatCryptoManager(session);
        try {
            keyStore = remoteCoreCryptoManager.getKeyStore();
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.keyStore", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        if (keyStore == null) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.keyStore");
            details.complete(BJobState.failed);
            return;
        }
        if (pkey == null) {
            pkey = (PrivateKey)keyStore.getKey(this.getServerCertAlias(), null);
        }
        if (pkey == null) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.privateKey");
            details.complete(BJobState.failed);
            return;
        }
        X509Certificate[] xChain = CertUtils.sortCertChain((List)certs.list()).toArray(new X509Certificate[0]);
        try {
            keyStore.setKeyEntry(this.getServerCertAlias(), (Key)pkey, null, xChain);
            keyStore.save();
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ImportSignedCertificate.failed.saveCert", (Throwable)e);
            details.complete(BJobState.failed);
            return;
        }
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

