/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.ui.certificate.BFileNameFormat;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fileNaming", type="BFileNameFormat", defaultValue="BFileNameFormat.DEFAULT"), @NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT")})
public class BExportCsrJobStep
extends BDeviceJobStep {
    public static final Property fileNaming = BExportCsrJobStep.newProperty((int)0, (BValue)BFileNameFormat.DEFAULT, null);
    public static final Property serverCertAlias = BExportCsrJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BExportCsrJobStep.class);

    public BFileNameFormat getFileNaming() {
        return (BFileNameFormat)this.get(fileNaming);
    }

    public void setFileNaming(BFileNameFormat v) {
        this.set(fileNaming, (BValue)v, null);
    }

    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BExportCsrJobStep() {
    }

    public BExportCsrJobStep(BFileNameFormat fileNaming, String serverCertAlias) {
        this.setFileNaming(fileNaming);
        this.setServerCertAlias(serverCertAlias);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        BIFile targetFile;
        FilePath exportPath;
        NPKCS10CertificationRequest csr;
        BPlatCryptoManager cryptoManager;
        BFoxSession session;
        ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);
        boolean stationRunning = util.hasRunningStation();
        if (stationRunning) {
            session = util.getEngagedFoxSession();
            BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
            cryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
        } else {
            session = util.getDaemonSession();
            cryptoManager = new BPlatCryptoManager((BDaemonSession)session);
        }
        try {
            csr = cryptoManager.generateCSR(this.getServerCertAlias(), null);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ExportCsrJobStep.failed.csr");
            details.complete(BJobState.failed);
            return;
        }
        if (csr == null) {
            details.failed("provisioningNiagara", "ExportCsrJobStep.failed.csr");
            details.complete(BJobState.failed);
            return;
        }
        BFileNameFormat fileNamingValue = this.getFileNaming();
        String fileName = fileNamingValue == BFileNameFormat.hostname ? ((NiagaraStation)device).getRemoteHost().getHostname() : (fileNamingValue == BFileNameFormat.hostId ? (stationRunning ? util.getRemoteDaemonPlatform().getHostId() : ((BDaemonSession)session).getHostProperties().getHostId()) : ((BINiagaraStation)device).getStationName());
        fileName = fileName + '.' + this.getServerCertAlias() + ".csr";
        try {
            exportPath = new FilePath("^csrExport").merge(fileName);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ExportCsrJobStep.failed.syntax");
            details.complete(BJobState.failed);
            return;
        }
        try {
            targetFile = BFileSystem.INSTANCE.makeFile(exportPath);
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ExportCsrJobStep.failed.create");
            details.complete(BJobState.failed);
            return;
        }
        try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(targetFile.getOutputStream()));){
            pem.writeObject((Object)new JcaPKCS10CertificationRequest(csr.getRequest().getEncoded()));
        }
        catch (Exception e) {
            details.failed("provisioningNiagara", "ExportCsrJobStep.failed.write");
            details.complete(BJobState.failed);
            return;
        }
        details.success();
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }
}

