/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.provisioningNiagara.bootstrap.BAbstractDiscoveryStep;
import com.tridium.provisioningNiagara.bootstrap.DhcpdLeaseSettingsDeviceInfo;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDhcpDiscoveryStep
extends BAbstractDiscoveryStep {
    public static final Type TYPE = Sys.loadType(BDhcpDiscoveryStep.class);
    private static final Logger logger = Logger.getLogger(BDhcpDiscoveryStep.class.getName());

    @Override
    public Type getType() {
        return TYPE;
    }

    protected void doRun(BBatchJobService svc, BNetworkStepDetails details, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) throws Exception {
        BNiagaraNetwork network = (BNiagaraNetwork)nw;
        BDaemonSession session = LocalSessionUtil.getLocalSession();
        if (session == null) {
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaFailed(arg_0, arg_1), logger::severe, "DhcpDiscoveryStep.unableToConnectToLocalPlatform", new String[0]);
            details.complete(BJobState.failed);
        } else {
            try {
                if (!DhcpdUtil.supportsDhcpd((BDaemonSession)session)) {
                    this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaFailed(arg_0, arg_1), logger::severe, "DhcpDiscoveryStep.dhcpdUnsupported", new String[0]);
                    details.complete(BJobState.failed);
                } else {
                    List leases = DhcpdUtil.getDhcpdLeases((BDaemonSession)session, (boolean)true);
                    this.updateConnectionInfo(details, devices, leases, DhcpdLeaseSettingsDeviceInfo::new);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, this.lexValue("unexpectedError", new Object[0]), e);
                throw e;
            }
        }
    }
}

