/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.batchJob.driver.BIPrivilegedDeviceJobStep;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.bootstrap.BDeviceBootstrapExt;
import com.tridium.provisioningNiagara.bootstrap.DeviceInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BAbstractDiscoveryStep
extends BNetworkJobStep
implements BIPrivilegedDeviceJobStep {
    public static final Type TYPE = Sys.loadType(BAbstractDiscoveryStep.class);
    private static final Logger logger = Logger.getLogger(BAbstractDiscoveryStep.class.getName());

    public Type getType() {
        return TYPE;
    }

    protected <T> void updateConnectionInfo(BNetworkStepDetails details, BDevice[] devices, Collection<T> discoveredDevices, Function<T, DeviceInfo> deviceInfoAdapter) {
        HashMap<String, DeviceInfo> devicesByName = new HashMap<String, DeviceInfo>();
        HashMap<String, DeviceInfo> devicesByHostId = new HashMap<String, DeviceInfo>();
        this.indexDiscoveredDevices(details, discoveredDevices, deviceInfoAdapter, devicesByName, devicesByHostId);
        boolean missingStation = false;
        for (BDevice device : devices) {
            if (this.updateStation(details, devicesByName, devicesByHostId, (BNiagaraStation)device)) continue;
            missingStation = true;
        }
        if (missingStation) {
            details.complete(BJobState.failed);
        } else {
            details.success();
        }
    }

    private <T> void indexDiscoveredDevices(BNetworkStepDetails details, Collection<T> devices, Function<T, DeviceInfo> deviceAdapter, Map<String, DeviceInfo> devicesByName, Map<String, DeviceInfo> devicesByHostId) {
        for (T device : devices) {
            logger.fine(device.toString());
            DeviceInfo deviceInfo = deviceAdapter.apply(device);
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaMessage(arg_0, arg_1), logger::info, "AbstractDiscoveryStep.discoveredDevice", deviceInfo.getStationName(), deviceInfo.getHostName(), Integer.toString(deviceInfo.getFoxPort()), deviceInfo.getHostId());
            if (!deviceInfo.getStationName().equals("")) {
                devicesByName.put(deviceInfo.getStationName(), deviceInfo);
            }
            if (deviceInfo.getHostId().equals("")) continue;
            devicesByHostId.put(deviceInfo.getHostId(), deviceInfo);
        }
    }

    private boolean updateStation(BNetworkStepDetails details, Map<String, DeviceInfo> devicesByName, Map<String, DeviceInfo> devicesByHostId, BNiagaraStation station) {
        logger.finest(() -> String.format("Processing station: %s", station.getStationName()));
        BDeviceBootstrapExt bootstrapDeviceExt = (BDeviceBootstrapExt)station.getMixIn(BDeviceBootstrapExt.TYPE);
        DeviceInfo deviceInfo = null;
        if (!"".equals(bootstrapDeviceExt.getTargetHostId().trim())) {
            logger.finest(() -> String.format("Looking for match for host id: %s", bootstrapDeviceExt.getTargetHostId()));
            deviceInfo = devicesByHostId.get(bootstrapDeviceExt.getTargetHostId());
            if (deviceInfo != null) {
                this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaSuccess(arg_0, arg_1), logger::info, "AbstractDiscoveryStep.hostIdMatchFound", station.getStationName(), deviceInfo.getStationName(), bootstrapDeviceExt.getTargetHostId());
            }
        } else {
            logger.finest(() -> String.format("Station %s has no host id set", station.getStationName()));
        }
        if (deviceInfo == null) {
            logger.finest(() -> String.format("Looking for match for station name: %s", station.getStationName()));
            deviceInfo = devicesByName.get(station.getStationName());
            if (deviceInfo != null) {
                this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaSuccess(arg_0, arg_1), logger::info, "AbstractDiscoveryStep.nameMatchFound", station.getStationName(), deviceInfo.getHostId());
            }
        }
        if (deviceInfo == null) {
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaFailed(arg_0, arg_1), logger::info, "AbstractDiscoveryStep.noMatchFound", station.getStationName());
        } else {
            this.updateConnection(details, station, deviceInfo);
        }
        return deviceInfo != null;
    }

    private void updateConnection(BNetworkStepDetails details, BNiagaraStation station, DeviceInfo deviceInfo) {
        logger.fine(() -> String.format("Updating connection info for station %s", station.getStationName()));
        BFoxClientConnection connection = station.getClientConnection();
        this.updateIfChanged(details, station.getStationName(), "Station Port", arg_0 -> ((BFoxClientConnection)connection).setPort(arg_0), connection.getPort(), deviceInfo.getFoxPort());
        BOrd address = BOrd.make((String)("ip:" + deviceInfo.getHostName()));
        this.updateIfChanged(details, station.getStationName(), "Address", arg_0 -> ((BNiagaraStation)station).setAddress(arg_0), station.getAddress(), address);
        this.updateIfChanged(details, station.getStationName(), "Use Foxs", arg_0 -> ((BFoxClientConnection)connection).setUseFoxs(arg_0), connection.getUseFoxs(), deviceInfo.getUseFoxs());
        BPlatformConnection platformConnection = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
        if (platformConnection != null) {
            this.updateIfChanged(details, station.getStationName(), "Use Secure Platform Connection", platformConnection::setSecure, platformConnection.getSecure(), deviceInfo.getUsePlatforms());
            this.updateIfChanged(details, station.getStationName(), "Platform Connection Port", platformConnection::setPort, platformConnection.getPort(), deviceInfo.getPlatformPort());
        } else {
            logger.warning(() -> String.format("No platform connection was found for station %s. Unable to update platform connection settings.", station.getStationName()));
        }
    }

    private <T> void updateIfChanged(BNetworkStepDetails details, String stationName, String propertyName, Consumer<T> setter, T currentValue, T newValue) {
        if (newValue != null && !currentValue.equals(newValue)) {
            setter.accept(newValue);
            this.logResult((arg_0, arg_1) -> ((BNetworkStepDetails)details).vaSuccess(arg_0, arg_1), logger::info, "AbstractDiscoveryStep.connectionUpdated", stationName, propertyName, currentValue.toString(), newValue.toString());
        }
    }

    protected void logResult(BiConsumer<String, String[]> detailsFunction, Consumer<Supplier<String>> logFunction, String lexKey, String ... args) {
        logFunction.accept(() -> this.getLexicon().getText(lexKey, (Object[])args));
        detailsFunction.accept(lexKey, args);
    }
}

