/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.io.BIEncodable;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BAsyncActionEvent
extends BSimple {
    public static final BAsyncActionEvent DEFAULT = new BAsyncActionEvent();
    public static final Type TYPE = Sys.loadType(BAsyncActionEvent.class);
    private BString invokeId;
    private BValue returnValue;
    private String string;
    private String exceptionMessage;

    public Type getType() {
        return TYPE;
    }

    protected BAsyncActionEvent() {
        this.invokeId = BString.DEFAULT;
        this.returnValue = null;
        this.exceptionMessage = null;
    }

    public BAsyncActionEvent(BString invokeId) {
        this(invokeId, (BValue)null);
    }

    public BAsyncActionEvent(BString invokeId, BValue returnValue) {
        this.invokeId = invokeId;
        this.returnValue = returnValue;
        this.exceptionMessage = null;
    }

    public BAsyncActionEvent(BString invokeId, Exception e) {
        this(invokeId, e.toString());
    }

    public BAsyncActionEvent(BString invokeId, String exceptionMessage) {
        this.invokeId = invokeId;
        this.returnValue = null;
        this.exceptionMessage = exceptionMessage;
    }

    public BString getInvokeId() {
        return this.invokeId;
    }

    public BValue getReturnValue() {
        if (this.exceptionMessage == null) {
            return this.returnValue;
        }
        throw new ActionInvokeException(this.exceptionMessage, null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAsyncActionEvent) {
            BAsyncActionEvent e = (BAsyncActionEvent)((Object)obj);
            return e.invokeId.equals((Object)this.invokeId);
        }
        return false;
    }

    public int hashCode() {
        return this.invokeId.hashCode();
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            s.append(this.invokeId.toString());
            if (this.exceptionMessage != null) {
                s.append("|exception|");
                s.append(this.exceptionMessage);
            }
            if (this.returnValue != null) {
                s.append('|');
                s.append(this.returnValue.getType().getTypeSpec().encodeToString());
                s.append('|');
                s.append(((BIEncodable)this.returnValue).encodeToString());
            }
            this.string = s.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        String remaining = s;
        int delim = remaining.indexOf(124);
        if (delim < 0) {
            return new BAsyncActionEvent(BString.make((String)s), (BValue)null);
        }
        BString aId = BString.make((String)remaining.substring(0, delim));
        if ((delim = (remaining = remaining.substring(delim + 1)).indexOf(124)) < 0) {
            return new BAsyncActionEvent(aId, (BValue)null);
        }
        String exceptionOrType = remaining.substring(0, delim);
        if (exceptionOrType.equals("exception")) {
            return new BAsyncActionEvent(aId, remaining.substring(delim + 1));
        }
        BTypeSpec rValType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(exceptionOrType);
        BValue rVal = (BValue)((BIEncodable)rValType.getInstance()).decodeFromString(remaining.substring(delim + 1));
        return new BAsyncActionEvent(aId, rVal);
    }

    public BSimple intern() {
        return this;
    }
}

