/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather.advisory;

import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryAlarmSourceInfo;

public class BAdvisoryContainer
extends BVector
implements BIAlarmSource {
    public static final Property status = BAdvisoryContainer.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property alarmEnable = BAdvisoryContainer.newProperty((int)0, (boolean)true, null);
    public static final Property alarmProperties = BAdvisoryContainer.newProperty((int)0, (BValue)new BAdvisoryAlarmSourceInfo(), null);
    public static final Type TYPE = Sys.loadType(BAdvisoryContainer.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.make((String)"module://weather/icons/weather.png"), (BIcon)BIcon.make((String)"module://icons/x16/badges/warning.png"));
    private AlarmSupport support = new AlarmSupport((BIAlarmSource)this, this.getAlarmProperties().getAlarmClass());

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public boolean getAlarmEnable() {
        return this.getBoolean(alarmEnable);
    }

    public void setAlarmEnable(boolean v) {
        this.setBoolean(alarmEnable, v, null);
    }

    public BAdvisoryAlarmSourceInfo getAlarmProperties() {
        return (BAdvisoryAlarmSourceInfo)this.get(alarmProperties);
    }

    public void setAlarmProperties(BAdvisoryAlarmSourceInfo v) {
        this.set(alarmProperties, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isNavChild() {
        return true;
    }

    public void started() {
        if (((BAdvisory[])this.getChildren(BAdvisory.class)).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public BBoolean ackAlarm(BAlarmRecord alarmRecord) {
        try {
            return BBoolean.make((boolean)this.support.ackAlarm(alarmRecord));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BBoolean.make((boolean)false);
        }
    }

    public void advisory(BAdvisory advisory) {
        BAdvisory existing = this.getAdvisory(advisory.getId());
        if (existing == null) {
            this.add("advisory?", (BValue)advisory, 1);
            BNameMap nameMap = (BNameMap)this.get("displayNames");
            if (nameMap == null) {
                HashMap<String, BFormat> map = new HashMap<String, BFormat>();
                map.put(advisory.getName(), BFormat.make((String)advisory.getWeatherSummary().getValue()));
                this.add("displayNames", (BValue)BNameMap.make(map), 4);
            } else {
                nameMap = BNameMap.make((BNameMap)nameMap, (String)advisory.getName(), (BFormat)BFormat.make((String)advisory.getWeatherSummary().getValue()));
                this.set("displayNames", (BValue)nameMap);
            }
            if (this.getAlarmEnable()) {
                BFacets facets = this.getAlarmProperties().makeAlarmData(BSourceState.offnormal);
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.state.getName(), (BIDataValue)advisory.getState().toDataValue());
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.description.getName(), (BIDataValue)BString.make((String)advisory.getDescription().getValue()));
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.instructions.getName(), (BIDataValue)BString.make((String)advisory.getInstructions().getValue()));
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.urgency.getName(), (BIDataValue)advisory.getUrgency().getValueValue().toDataValue());
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.severity.getName(), (BIDataValue)advisory.getSeverity().getValueValue().toDataValue());
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.certainty.getName(), (BIDataValue)advisory.getCertainty().getValueValue().toDataValue());
                facets = BFacets.make((BFacets)facets, (String)BAdvisory.expires.getName(), (BIDataValue)advisory.getExpires());
                facets = BFacets.make((BFacets)facets, (String)"msgText", (BIDataValue)BString.make((String)advisory.getWeatherSummary().getValue()));
                try {
                    this.support.setAlarmClass(this.getAlarmProperties().getAlarmClass());
                    this.support.newOffnormalAlarm(facets);
                }
                catch (Exception e) {
                    BWeatherService.log.log(Level.SEVERE, "Unable to create weather advisory alarm.", e);
                }
            }
        } else {
            existing.copyFrom((BComplex)advisory);
        }
        BCurrentConditions currentConditions = (BCurrentConditions)this.getParent();
        currentConditions.setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)true));
        currentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)true));
        ((BWeatherReport)currentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)currentConditions.getParent()).getStatus(), (boolean)true));
    }

    public void added(Property property, Context context) {
        if (this.isRunning() && property.getType().is(BAdvisory.TYPE)) {
            BCurrentConditions currentConditions = (BCurrentConditions)this.getParent();
            currentConditions.setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)true));
            currentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)true));
            ((BWeatherReport)currentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)currentConditions.getParent()).getStatus(), (boolean)true));
        }
        if (((BAdvisory[])this.getChildren(BAdvisory.class)).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (this.isRunning() && property.getType().is(BAdvisory.TYPE)) {
            if (this.getAlarmEnable() && ((BAdvisory[])this.getChildren(BAdvisory.class)).length == 0) {
                try {
                    this.support.toNormal(context);
                }
                catch (Exception e) {
                    BWeatherService.log.log(Level.SEVERE, "Unable to return advisory alarms to normal.", e);
                }
            }
            boolean inAlarm = ((BAdvisory[])this.getChildren(BAdvisory.class)).length > 0;
            BCurrentConditions currentConditions = (BCurrentConditions)this.getParent();
            currentConditions.setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)inAlarm));
            currentConditions.getState().setStatus(BStatus.makeAlarm((BStatus)currentConditions.getStatus(), (boolean)inAlarm));
            ((BWeatherReport)currentConditions.getParent()).setStatus(BStatus.makeAlarm((BStatus)((BWeatherReport)currentConditions.getParent()).getStatus(), (boolean)inAlarm));
        }
        if (((BAdvisory[])this.getChildren(BAdvisory.class)).length > 0) {
            this.setStatus(BStatus.alarm);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public boolean hasAdvisories() {
        this.lease();
        return ((BAdvisory[])this.getChildren(BAdvisory.class)).length > 0;
    }

    public int getAdvisoryCount() {
        this.lease();
        return ((BAdvisory[])this.getChildren(BAdvisory.class)).length;
    }

    public BAdvisory getMostRecent() {
        this.lease(2);
        BAdvisory[] advisories = (BAdvisory[])this.getChildren(BAdvisory.class);
        if (advisories.length > 0) {
            SortUtil.sort((Object[])advisories, (Object[])advisories, (Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    BAdvisory advisory1 = (BAdvisory)((Object)arg0);
                    BAdvisory advisory2 = (BAdvisory)((Object)arg1);
                    return advisory2.getEffective().compareTo((Object)advisory1.getEffective());
                }
            });
            return advisories[0];
        }
        return null;
    }

    public BAdvisory getMostUrgent() {
        this.lease(2);
        BAdvisory[] advisories = (BAdvisory[])this.getChildren(BAdvisory.class);
        if (advisories.length > 0) {
            SortUtil.sort((Object[])advisories, (Object[])advisories, (Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    BAdvisory advisory1 = (BAdvisory)((Object)arg0);
                    BAdvisory advisory2 = (BAdvisory)((Object)arg1);
                    int value = advisory1.getUrgency().getValue().compareTo((Object)advisory2.getUrgency().getValue());
                    if (value != 0) {
                        return value;
                    }
                    return advisory2.getEffective().compareTo((Object)advisory1.getEffective());
                }
            });
            return advisories[0];
        }
        return null;
    }

    public BAdvisory getMostSevere() {
        this.lease(2);
        BAdvisory[] advisories = (BAdvisory[])this.getChildren(BAdvisory.class);
        if (advisories.length > 0) {
            SortUtil.sort((Object[])advisories, (Object[])advisories, (Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    BAdvisory advisory1 = (BAdvisory)((Object)arg0);
                    BAdvisory advisory2 = (BAdvisory)((Object)arg1);
                    int value = advisory1.getSeverity().getValue().compareTo((Object)advisory2.getSeverity().getValue());
                    if (value != 0) {
                        return value;
                    }
                    return advisory2.getEffective().compareTo((Object)advisory1.getEffective());
                }
            });
            return advisories[0];
        }
        return null;
    }

    public BAdvisory getMostCertain() {
        this.lease(2);
        BAdvisory[] advisories = (BAdvisory[])this.getChildren(BAdvisory.class);
        if (advisories.length > 0) {
            SortUtil.sort((Object[])advisories, (Object[])advisories, (Comparator)new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    BAdvisory advisory1 = (BAdvisory)((Object)arg0);
                    BAdvisory advisory2 = (BAdvisory)((Object)arg1);
                    return advisory1.getCertainty().getValue().compareTo((Object)advisory2.getCertainty().getValue());
                }
            });
            return advisories[0];
        }
        return null;
    }

    public BAdvisory getAdvisory(BValue id) {
        BAdvisory[] advisories;
        for (BAdvisory advisory : advisories = (BAdvisory[])this.getChildren(BAdvisory.class)) {
            if (!advisory.getId().equals((Object)id)) continue;
            return advisory;
        }
        return null;
    }
}

