/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.weather.BWeatherReport;

public class BWeatherService
extends BAbstractService {
    public static final Property updatePeriod = BWeatherService.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property airQualityApiKey = BWeatherService.newProperty((int)0, (String)"", null);
    public static final Action updateWeatherReports = BWeatherService.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BWeatherService.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");
    private CoalesceQueue queue = new CoalesceQueue();
    private Worker worker;
    private Clock.Ticket updateTicket;
    public static final Logger log = Logger.getLogger("weather");

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    public String getAirQualityApiKey() {
        return this.getString(airQualityApiKey);
    }

    public void setAirQualityApiKey(String v) {
        this.setString(airQualityApiKey, v, null);
    }

    public void updateWeatherReports() {
        this.invoke(updateWeatherReports, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void serviceStarted() throws Exception {
        if (this.worker == null) {
            this.worker = new Worker((Worker.ITodo)this.queue);
            this.worker.start("WeatherService");
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateWeatherReports, null);
        }
    }

    public void serviceStopped() throws Exception {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "BWeatherService.serviceStopped");
        }
    }

    protected void enabled() {
        this.invoke(updateWeatherReports, null);
        this.updateStatus();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "BWeatherService.enabled");
        }
    }

    protected void disabled() {
        this.updateStatus();
        this.queue.clear();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "BWeatherService.disabled");
        }
    }

    public BWeatherReport[] getReports() {
        return this.getReports((BComponent)this);
    }

    private BWeatherReport[] getReports(BComponent component) {
        BFolder[] folders = (BFolder[])component.getChildren(BFolder.class);
        if (folders.length > 0) {
            Array array = new Array(BWeatherReport.class);
            array.addAll(this.getChildren(BWeatherReport.class));
            for (BFolder folder : folders) {
                array.addAll((Object[])this.getReports((BComponent)folder));
            }
            return (BWeatherReport[])array.trim();
        }
        return (BWeatherReport[])component.getChildren(BWeatherReport.class);
    }

    Queue getQueue() {
        return this.queue;
    }

    public void doUpdateWeatherReports() {
        BWeatherReport[] reports;
        if (!this.getEnabled()) {
            return;
        }
        for (BWeatherReport report : reports = this.getReports()) {
            this.getQueue().enqueue((Object)new Invocation((BComponent)report, BWeatherReport.updateWeatherReport, null, null));
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled) || property.equals(updatePeriod) || property.equals(airQualityApiKey)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.getUpdatePeriod().getMillis() != 0L) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateWeatherReports, null);
            }
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"Weather", 2);
        out.prop((Object)"queueSize", this.queue.size());
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(transports={@Transport(type=TransportType.fox)}, permissions="r")
    public BVector getReports(Object stationName, Context cx) {
        BVector bVector;
        block10: {
            BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)niagaraNetwork.getStation(stationName.toString());
            if (station == null) {
                throw new Exception("Station not found in Niagara Network: " + stationName);
            }
            station.lease(1);
            BIpHost host = (BIpHost)station.getRemoteHost();
            BFoxSession session = BFoxSession.make((String)station.getName(), (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
            if (session == null) {
                throw new RuntimeException("Unable to connect to station " + stationName);
            }
            BIUserCredentials credentials = station.getClientConnection().getCredentials();
            session.setCredentials((BICredentials)credentials);
            session.getConnection().setCredentials(credentials);
            session.getConnection().setAuthenticationClient((AuthenticationClient)session.getConnection());
            if (session == null) {
                return new BVector();
            }
            try {
                session.engageNoRetry(this.getType().toString() + "_getReports");
                BVector stationVector = new BVector();
                BOrd ord = BOrd.make((String)"station:|slot:/|bql:select displayName, slotPath from weather:WeatherReport");
                BITable reportTable = (BITable)ord.resolve((BObject)session).get();
                ColumnList columns = reportTable.getColumns();
                TableCursor cursor = reportTable.cursor();
                while (cursor.next()) {
                    BComponent value = new BComponent();
                    value.add("name", (BValue)((BString)cursor.cell(columns.get(0))));
                    value.add("ord", (BValue)BOrd.make((String)cursor.cell(columns.get(1)).toString()));
                    stationVector.add(null, (BValue)value);
                }
                bVector = stationVector;
                if (session == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        session.disengage(this.getType().toString() + "_getReports");
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new BVector();
                }
            }
            session.disengage(this.getType().toString() + "_getReports");
        }
        return bVector;
    }

    public BIcon getIcon() {
        return icon;
    }
}

