/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import com.tridium.weather.nws.BNwsWeatherProvider;
import java.util.logging.Level;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.LexiconModule;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherService;

public class BWeatherReport
extends BComponent
implements BIStatus {
    public static final Property status = BWeatherReport.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property provider = BWeatherReport.newProperty((int)0, (BValue)new BNwsWeatherProvider(), null);
    public static final Property current = BWeatherReport.newProperty((int)0, (BValue)new BCurrentConditions(), null);
    public static final Action updateWeatherReport = BWeatherReport.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BWeatherReport.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weatherReport.png");
    static LexiconModule lex = LexiconModule.make((String)"weather");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BWeatherProvider getProvider() {
        return (BWeatherProvider)this.get(provider);
    }

    public void setProvider(BWeatherProvider v) {
        this.set(provider, (BValue)v, null);
    }

    public BCurrentConditions getCurrent() {
        return (BCurrentConditions)this.get(current);
    }

    public void setCurrent(BCurrentConditions v) {
        this.set(current, (BValue)v, null);
    }

    public void updateWeatherReport() {
        this.invoke(updateWeatherReport, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.updateWeatherReport();
    }

    public BForecast[] getForecast() {
        return (BForecast[])this.getChildren(BForecast.class);
    }

    public void setForecast(BForecast[] forecast) {
        for (int i = 0; i < forecast.length; ++i) {
            String name = "day" + i;
            BForecast f = (BForecast)this.get(name);
            if (f != null) {
                SlotCursor c = f.getProperties();
                while (c.next()) {
                    Property p = c.property();
                    f.set(p, forecast[i].get(p).newCopy(true));
                }
                continue;
            }
            this.add(name, (BValue)forecast[i]);
        }
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.isProperty() && slot.asProperty().getType().is(BForecast.TYPE)) {
            String name = slot.getName();
            int index = Integer.parseInt(name.substring("day".length()));
            if (index == 0) {
                return lex.getText("today", cx);
            }
            if (index == 1) {
                return lex.getText("tomorrow", cx);
            }
            BAbsTime day = BAbsTime.now();
            for (int i = 0; i < index; ++i) {
                day = day.nextDay();
            }
            return day.getWeekday().getDisplayTag(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(provider)) {
            this.updateWeatherReport();
        }
        super.changed(property, context);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(updateWeatherReport)) {
            if (this.isRunning()) {
                BWeatherService ws = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
                ws.getQueue().enqueue((Object)new Invocation((BComponent)this, action, arg, cx));
            }
            return null;
        }
        return super.post(action, arg, cx);
    }

    public void doUpdateWeatherReport() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BWeatherService ws = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
            if (ws.getEnabled()) {
                BWeatherProvider provider = this.getProvider();
                provider.updateReport();
                provider.updateSunStatus();
            }
        }
        catch (Exception e) {
            BWeatherService.log.log(Level.SEVERE, "Unable to update", e);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

