/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;

public class BForecast
extends BComponent
implements BIComparable {
    public static final Property status = BForecast.newProperty((int)11, (BValue)BStatus.ok, null);
    public static final Property lastUpdate = BForecast.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property date = BForecast.newProperty((int)3, (BValue)BAbsTime.now(), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.FALSE));
    public static final Property sunrise = BForecast.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property sunset = BForecast.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property high = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property low = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property precipChance = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property weatherSummary = BForecast.newProperty((int)3, (BValue)new BStatusString("", BStatus.nullStatus), null);
    public static final Property state = BForecast.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWeatherState.clear), null);
    public static final Property ozone = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"parts per million"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property particulateMatter = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"micrograms per cubic meter"), (String)"precision", (BIDataValue)BDouble.make((double)1.0)));
    public static final Property humidity = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent relative humidity"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property windSpeed = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    public static final Type TYPE = Sys.loadType(BForecast.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public BAbsTime getDate() {
        return (BAbsTime)this.get(date);
    }

    public void setDate(BAbsTime v) {
        this.set(date, (BValue)v, null);
    }

    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    public void setSunrise(BTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    public void setSunset(BTime v) {
        this.set(sunset, (BValue)v, null);
    }

    public BStatusNumeric getHigh() {
        return (BStatusNumeric)this.get(high);
    }

    public void setHigh(BStatusNumeric v) {
        this.set(high, (BValue)v, null);
    }

    public BStatusNumeric getLow() {
        return (BStatusNumeric)this.get(low);
    }

    public void setLow(BStatusNumeric v) {
        this.set(low, (BValue)v, null);
    }

    public BStatusNumeric getPrecipChance() {
        return (BStatusNumeric)this.get(precipChance);
    }

    public void setPrecipChance(BStatusNumeric v) {
        this.set(precipChance, (BValue)v, null);
    }

    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    public void setWeatherSummary(BStatusString v) {
        this.set(weatherSummary, (BValue)v, null);
    }

    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    public void setState(BStatusEnum v) {
        this.set(state, (BValue)v, null);
    }

    public BStatusNumeric getOzone() {
        return (BStatusNumeric)this.get(ozone);
    }

    public void setOzone(BStatusNumeric v) {
        this.set(ozone, (BValue)v, null);
    }

    public BStatusNumeric getParticulateMatter() {
        return (BStatusNumeric)this.get(particulateMatter);
    }

    public void setParticulateMatter(BStatusNumeric v) {
        this.set(particulateMatter, (BValue)v, null);
    }

    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    public void setHumidity(BStatusNumeric v) {
        this.set(humidity, (BValue)v, null);
    }

    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    public void setWindSpeed(BStatusNumeric v) {
        this.set(windSpeed, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void setSun(BAbsTime date, double lat, double lon) {
        BSunPosition sun = BSunPosition.make(lat, lon, date);
        this.setSunrise(BTime.make((BAbsTime)sun.getSunrise()));
        this.setSunset(BTime.make((BAbsTime)sun.getSunset()));
    }

    public void changed(Property property, Context context) {
        if (property.equals(status)) {
            BStatusValue[] values;
            for (BStatusValue value : values = (BStatusValue[])this.getChildren(BStatusValue.class)) {
                value.setStatus(this.getStatus());
            }
        }
        super.changed(property, context);
    }

    public String toString(Context context) {
        BFacets mergedFacets = this.getSlotFacets((Slot)high);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)high));
        }
        String max = this.getHigh().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)low);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)low));
        }
        String min = this.getLow().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)precipChance);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)precipChance));
        }
        String pop = this.getPrecipChance().getValueValue().toString((Context)mergedFacets);
        String sum = this.getState().getValueValue().toString();
        if (this.getHigh().getStatus().isNull()) {
            max = "-";
        }
        if (this.getLow().getStatus().isNull()) {
            min = "-";
        }
        if (this.getPrecipChance().getStatus().isNull()) {
            pop = "-";
        }
        if (this.getState().getStatus().isNull()) {
            sum = "-";
        }
        return max + '/' + min + ", " + sum + ", " + pop + ' ' + this.getStatus().toString(context);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof BForecast)) {
            return 0;
        }
        BForecast forecast = (BForecast)((Object)obj);
        return Double.compare(forecast.getHigh().getValue(), this.getHigh().getValue());
    }

    public BIcon getIcon() {
        return icon;
    }
}

