/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.weather.advisory.BAdvisoryContainer;

public class BCurrentConditions
extends BComponent
implements BIComparable {
    public static final Property status = BCurrentConditions.newProperty((int)75, (BValue)BStatus.ok, null);
    public static final Property lastUpdate = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property observed = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Property sunrise = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property sunset = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    public static final Property sunDown = BCurrentConditions.newProperty((int)3, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property temp = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property weatherSummary = BCurrentConditions.newProperty((int)3, (BValue)new BStatusString("", BStatus.nullStatus), null);
    public static final Property state = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWeatherState.clear), null);
    public static final Property humidity = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent relative humidity"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property windDirection = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWindDirection.north, BStatus.nullStatus), null);
    public static final Property windSpeed = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    public static final Property windGust = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    public static final Property windChill = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property pressure = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"inches of mercury")));
    public static final Property dewPoint = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property heatIndex = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    public static final Property visibility = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"mile")));
    public static final Property ozone = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"parts per million"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    public static final Property particulateMatter = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"micrograms per cubic meter"), (String)"precision", (BIDataValue)BDouble.make((double)1.0)));
    public static final Property advisories = BCurrentConditions.newProperty((int)0, (BValue)new BAdvisoryContainer(), null);
    public static final Type TYPE = Sys.loadType(BCurrentConditions.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    public BAbsTime getObserved() {
        return (BAbsTime)this.get(observed);
    }

    public void setObserved(BAbsTime v) {
        this.set(observed, (BValue)v, null);
    }

    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    public void setSunrise(BTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    public void setSunset(BTime v) {
        this.set(sunset, (BValue)v, null);
    }

    public BStatusBoolean getSunDown() {
        return (BStatusBoolean)this.get(sunDown);
    }

    public void setSunDown(BStatusBoolean v) {
        this.set(sunDown, (BValue)v, null);
    }

    public BStatusNumeric getTemp() {
        return (BStatusNumeric)this.get(temp);
    }

    public void setTemp(BStatusNumeric v) {
        this.set(temp, (BValue)v, null);
    }

    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    public void setWeatherSummary(BStatusString v) {
        this.set(weatherSummary, (BValue)v, null);
    }

    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    public void setState(BStatusEnum v) {
        this.set(state, (BValue)v, null);
    }

    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    public void setHumidity(BStatusNumeric v) {
        this.set(humidity, (BValue)v, null);
    }

    public BStatusEnum getWindDirection() {
        return (BStatusEnum)this.get(windDirection);
    }

    public void setWindDirection(BStatusEnum v) {
        this.set(windDirection, (BValue)v, null);
    }

    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    public void setWindSpeed(BStatusNumeric v) {
        this.set(windSpeed, (BValue)v, null);
    }

    public BStatusNumeric getWindGust() {
        return (BStatusNumeric)this.get(windGust);
    }

    public void setWindGust(BStatusNumeric v) {
        this.set(windGust, (BValue)v, null);
    }

    public BStatusNumeric getWindChill() {
        return (BStatusNumeric)this.get(windChill);
    }

    public void setWindChill(BStatusNumeric v) {
        this.set(windChill, (BValue)v, null);
    }

    public BStatusNumeric getPressure() {
        return (BStatusNumeric)this.get(pressure);
    }

    public void setPressure(BStatusNumeric v) {
        this.set(pressure, (BValue)v, null);
    }

    public BStatusNumeric getDewPoint() {
        return (BStatusNumeric)this.get(dewPoint);
    }

    public void setDewPoint(BStatusNumeric v) {
        this.set(dewPoint, (BValue)v, null);
    }

    public BStatusNumeric getHeatIndex() {
        return (BStatusNumeric)this.get(heatIndex);
    }

    public void setHeatIndex(BStatusNumeric v) {
        this.set(heatIndex, (BValue)v, null);
    }

    public BStatusNumeric getVisibility() {
        return (BStatusNumeric)this.get(visibility);
    }

    public void setVisibility(BStatusNumeric v) {
        this.set(visibility, (BValue)v, null);
    }

    public BStatusNumeric getOzone() {
        return (BStatusNumeric)this.get(ozone);
    }

    public void setOzone(BStatusNumeric v) {
        this.set(ozone, (BValue)v, null);
    }

    public BStatusNumeric getParticulateMatter() {
        return (BStatusNumeric)this.get(particulateMatter);
    }

    public void setParticulateMatter(BStatusNumeric v) {
        this.set(particulateMatter, (BValue)v, null);
    }

    public BAdvisoryContainer getAdvisories() {
        return (BAdvisoryContainer)this.get(advisories);
    }

    public void setAdvisories(BAdvisoryContainer v) {
        this.set(advisories, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void setSun(double lon, double lat) {
        BSunPosition sun = BSunPosition.make(lat, lon);
        this.setSunrise(BTime.make((BAbsTime)sun.getSunrise()));
        this.setSunset(BTime.make((BAbsTime)sun.getSunset()));
        this.setSunDown(new BStatusBoolean(sun.getCurrentElevation() < 0.0, BStatus.ok));
    }

    public void changed(Property property, Context context) {
        if (property.equals(status)) {
            BStatusValue[] values;
            for (BStatusValue value : values = (BStatusValue[])this.getChildren(BStatusValue.class)) {
                value.setStatus(BStatus.make((int)(value.getStatus().getBits() & 0x48 | this.getStatus().getBits() & 0x16)));
            }
        }
        super.changed(property, context);
    }

    public String toString(Context context) {
        BFacets mergedFacets = this.getSlotFacets((Slot)temp);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)temp));
        }
        String stemp = this.getTemp().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)state);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)state));
        }
        String sstate = this.getState().getValueValue().toString((Context)mergedFacets);
        if (this.getTemp().getStatus().isNull()) {
            stemp = "-";
        }
        if (this.getState().getStatus().isNull()) {
            sstate = "-";
        }
        return stemp + ", " + sstate + ' ' + this.getStatus().toString(context);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof BCurrentConditions)) {
            return 0;
        }
        BCurrentConditions conditions = (BCurrentConditions)((Object)obj);
        return Double.compare(this.getTemp().getValue(), conditions.getTemp().getValue());
    }

    public BIcon getIcon() {
        return icon;
    }
}

