/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaException;
import javax.baja.timezone.BTimeZone;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryUrgency;
import javax.baja.xml.XElem;

public class NwsCurrentReader {
    BNwsWeatherProvider provider;
    private static final Logger log = Logger.getLogger("weather");
    private static final int MAX_REDIRECTS = 5;

    public NwsCurrentReader(BNwsWeatherProvider provider) {
        this.provider = provider;
    }

    XElem getFeed(NwsStationList.Station station) throws Exception {
        String uri = this.provider.getConditionsPath() + station.id + ".xml";
        return this.getFeed(station, this.provider.getConditionsServer(), uri);
    }

    XElem getFeed(NwsStationList.Station station, String host, String uri) throws Exception {
        try {
            return FeedReader.getXmlFeed(host, uri, 5, false);
        }
        catch (IOException exception) {
            throw new BajaException("Unable to get NWS Current Conditions feed", (Throwable)exception);
        }
    }

    public void getCurrent(BNwsWeatherProvider provider, BCurrentConditions cw, NwsStationList.Station station) throws Exception {
        XElem root = this.getFeed(station);
        cw.setSun(station.longitude, station.latitude);
        try {
            String rfc822 = root.elem("observation_time_rfc822").string();
            SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z");
            XElem[] calendar = Calendar.getInstance();
            calendar.setTime(format.parse(rfc822));
            BTimeZone obsTz = BTimeZone.makeIgnoringCache((String)"nws_CurrentObservations", (int)(calendar.get(15) + calendar.get(16)));
            BAbsTime obs = BAbsTime.make((int)calendar.get(1), (BMonth)BMonth.make((int)calendar.get(2)), (int)calendar.get(5), (int)calendar.get(11), (int)calendar.get(12), (int)calendar.get(13), (int)0, (BTimeZone)obsTz);
            cw.setObserved(BAbsTime.make((BAbsTime)obs, (BTimeZone)BTimeZone.getLocal()));
        }
        catch (Exception e) {
            cw.setObserved(BAbsTime.NULL);
        }
        XElem[] elems = root.elems();
        String weatherSummary = null;
        for (XElem elem : elems) {
            String name = elem.name();
            if (elem.contentSize() == 0) continue;
            String value = String.valueOf(elem.content(0));
            if (name.equals("temp_f")) {
                NwsCurrentReader.setStatusNumeric(cw.getTemp(), value);
                continue;
            }
            if (name.equals("weather")) {
                weatherSummary = value;
                NwsCurrentReader.setStatusString(cw.getWeatherSummary(), weatherSummary);
                continue;
            }
            if (name.equals("location")) {
                provider.setLocation(value);
                continue;
            }
            if (name.equals("wind_dir")) {
                this.setWindDir(cw.getWindDirection(), value);
                continue;
            }
            if (name.equals("wind_mph")) {
                NwsCurrentReader.setStatusNumeric(cw.getWindSpeed(), value);
                continue;
            }
            if (name.equals("wind_gust_mph")) {
                NwsCurrentReader.setStatusNumeric(cw.getWindGust(), value);
                continue;
            }
            if (name.equals("windchill_f")) {
                NwsCurrentReader.setStatusNumeric(cw.getWindChill(), value);
                continue;
            }
            if (name.equals("relative_humidity")) {
                NwsCurrentReader.setStatusNumeric(cw.getHumidity(), value);
                continue;
            }
            if (name.equals("pressure_in")) {
                NwsCurrentReader.setStatusNumeric(cw.getPressure(), value);
                continue;
            }
            if (name.equals("heat_index_f")) {
                NwsCurrentReader.setStatusNumeric(cw.getHeatIndex(), value);
                continue;
            }
            if (name.equals("dewpoint_f")) {
                NwsCurrentReader.setStatusNumeric(cw.getDewPoint(), value);
                continue;
            }
            if (!name.equals("visibility_mi")) continue;
            NwsCurrentReader.setStatusNumeric(cw.getVisibility(), value);
        }
        BAdvisory advisory = cw.getAdvisories().getMostUrgent();
        if (advisory != null && (advisory.getUrgency().equals((Object)BAdvisoryUrgency.immediate) || advisory.getUrgency().equals((Object)BAdvisoryUrgency.expected))) {
            if (!advisory.getState().equals((Object)BWeatherState.unknown)) {
                cw.getState().setValue(advisory.getState().getValue());
            } else {
                cw.getState().setValue((BEnum)BWeatherState.make(weatherSummary));
            }
        } else {
            cw.getState().setValue((BEnum)BWeatherState.make(weatherSummary));
        }
        try {
            if (cw.getTemp().getValue() > -50.0 && cw.getTemp().getValue() < 50.0 && cw.getWindSpeed().getValue() > 3.0 && cw.getWindSpeed().getValue() < 110.0) {
                double windChill = 35.74 + 0.6215 * cw.getTemp().getValue() + (0.4275 * cw.getTemp().getValue() - 35.75) * Math.pow(cw.getWindSpeed().getValue(), 0.16);
                cw.getWindChill().setValue(windChill);
                cw.getWindChill().setStatusNull(false);
            } else {
                cw.getWindChill().setStatusNull(true);
                cw.getWindChill().setValue(Double.NaN);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to calculate wind chill", e);
            cw.getWindChill().setStatusNull(true);
            cw.getWindChill().setValue(Double.NaN);
        }
        try {
            if (cw.getTemp().getValue() > 80.0 && cw.getDewPoint().getValue() > 60.0 && cw.getHumidity().getValue() > 40.0) {
                double r = cw.getHumidity().getValue();
                double t = cw.getTemp().getValue();
                double heatIndex = -42.379 + 2.04901523 * t + 10.14333127 * r - 0.22475541 * t * r - 6.83783 * Math.pow(10.0, -3.0) * Math.pow(t, 2.0) - 5.481717 * Math.pow(10.0, -2.0) * Math.pow(r, 2.0) + 1.22874 * Math.pow(10.0, -3.0) * Math.pow(t, 2.0) * r + 8.5282 * Math.pow(10.0, -4.0) * t * Math.pow(r, 2.0) - 1.99 * Math.pow(10.0, -6.0) * Math.pow(t, 2.0) * Math.pow(r, 2.0);
                cw.getHeatIndex().setStatus(BStatus.ok);
                cw.getHeatIndex().setValue(heatIndex);
            } else {
                cw.getHeatIndex().setStatusNull(true);
                cw.getHeatIndex().setValue(Double.NaN);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to calculate head index", e);
            cw.getHeatIndex().setStatusNull(true);
            cw.getHeatIndex().setValue(Double.NaN);
        }
        cw.setLastUpdate(BAbsTime.now());
    }

    private void setWindDir(BStatusEnum e, String v) throws Exception {
        if (v.equals("North")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.north);
        } else if (v.equals("Northeast")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.northeast);
        } else if (v.equals("East")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.east);
        } else if (v.equals("Southeast")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.southeast);
        } else if (v.equals("South")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.south);
        } else if (v.equals("Southwest")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.southwest);
        } else if (v.equals("West")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.west);
        } else if (v.equals("Northwest")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.northwest);
        } else if (v.equals("Variable")) {
            NwsCurrentReader.setStatusEnum(e, (BEnum)BWindDirection.variable);
        } else {
            NwsCurrentReader.setStatusEnum(e, null);
        }
    }

    private static void setStatusString(BStatusString n, String v) throws Exception {
        try {
            if (v != null && !v.equalsIgnoreCase("NULL")) {
                n.setStatusNull(false);
                n.setValue(v);
            } else {
                n.setStatusNull(true);
            }
        }
        catch (Exception e) {
            n.setStatusNull(true);
        }
    }

    private static void setStatusNumeric(BStatusNumeric n, String v) throws Exception {
        try {
            if (v != null && !v.equalsIgnoreCase("NULL")) {
                n.setStatusNull(false);
                n.setValue(Double.parseDouble(v));
            } else {
                n.setStatusNull(true);
            }
        }
        catch (Exception e) {
            n.setStatusNull(true);
        }
    }

    private static void setStatusEnum(BStatusEnum se, BEnum v) throws Exception {
        try {
            if (v != null) {
                se.setStatusNull(false);
                se.setValue(v);
            } else {
                se.setStatusNull(true);
            }
        }
        catch (Exception e) {
            se.setStatusNull(true);
        }
    }
}

