/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.weather.nws.BNwsWeatherProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpsConnection;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class FeedReader {
    public static XElem getXmlFeed(String host, String uri, int maxRedirects, boolean secure) throws IOException {
        return (XElem)FeedReader.getFeed(host, uri, maxRedirects, secure, true);
    }

    public static JSONObject getJsonFeed(String host, String uri, int maxRedirects, boolean secure) throws IOException {
        return (JSONObject)FeedReader.getFeed(host, uri, maxRedirects, secure, false);
    }

    public static JSONArray getJsonArrayFeed(String host, String uri, int maxRedirects, boolean secure) throws IOException {
        return (JSONArray)FeedReader.getFeed(host, uri, maxRedirects, secure, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFeed(String host, String uri, int maxRedirects, boolean secure, boolean isXml) throws IOException {
        XElem element;
        Object connection;
        String urlHost = host;
        String urlUri = uri;
        boolean isSecure = secure;
        int redirectCount = 0;
        URL savedUrl = new URL((isSecure ? "https://" : "http://") + urlHost + urlUri);
        while (true) {
            URL url;
            String location;
            connection = isSecure ? new HttpsConnection((BHost)new BIpHost(urlHost), 443, urlUri) : new HttpConnection((BHost)new BIpHost(urlHost), 80, urlUri);
            connection.setUserAgent("NWS Weather Service");
            connection.setTimeout(BNwsWeatherProvider.READ_TIMEOUT);
            if (!isXml) {
                connection.setRequestHeader("Accept", "application/geo+json");
            }
            connection.connect(BNwsWeatherProvider.CONNECT_TIMEOUT);
            if (connection.getStatusCode() != 301 && connection.getStatusCode() != 302) break;
            if (++redirectCount >= maxRedirects) {
                connection.close();
                throw new IOException("Maximum number of redirects exceeded");
            }
            if (BWeatherService.log.isLoggable(Level.FINE)) {
                BWeatherService.log.log(Level.FINE, "Redirect to " + connection.getResponseHeader("Location"));
            }
            if ((location = connection.getResponseHeader("Location")).charAt(0) == '/') {
                location = (isSecure ? "https://" : "http://") + urlHost + location;
            }
            if (savedUrl.equals(url = new URL(location))) {
                connection.close();
                throw new IOException("Redirect URL same as requested URL: " + urlHost + urlUri);
            }
            savedUrl = url;
            urlHost = url.getHost();
            String query = url.getQuery();
            urlUri = url.getPath() + (query == null ? "" : "?" + query);
            isSecure = url.getProtocol().equals("https");
            connection.close();
        }
        int statusCode = connection.getStatusCode();
        if (statusCode / 100 != 2) {
            connection.close();
            throw new IOException("Bad Status Code: " + statusCode);
        }
        try {
            BufferedReader reader = null;
            StringBuilder builder = new StringBuilder();
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
            }
            catch (IOException e) {
                connection.close();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        connection.close();
                    }
                }
            }
            if (isXml) {
                XParser parser = XParser.make((String)builder.toString());
                element = parser.parse();
            } else {
                try {
                    element = new JSONObject(builder.toString());
                }
                catch (Exception e) {
                    element = new JSONArray(builder.toString());
                }
            }
        }
        catch (Exception exception) {
            connection.close();
            throw new IOException("Could not parse response: " + exception.getMessage(), exception);
        }
        connection.close();
        return element;
    }
}

