/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.EpaCurrentReader;
import com.tridium.weather.nws.EpaForecastReader;
import com.tridium.weather.nws.NwsCurrentReader;
import com.tridium.weather.nws.NwsForecastReader;
import com.tridium.weather.nws.NwsStationList;
import com.tridium.weather.nws.advisory.BNwsAdvisoryAlarmExt;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherProvider;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;

public class BNwsWeatherProvider
extends BWeatherProvider {
    public static final Property stationId = BNwsWeatherProvider.newProperty((int)0, (String)"KRIC", null);
    public static final Property outlook = BNwsWeatherProvider.newProperty((int)0, (int)7, null);
    public static final Property location = BNwsWeatherProvider.newProperty((int)1, (String)"", null);
    public static final Property longitude = BNwsWeatherProvider.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    public static final Property latitude = BNwsWeatherProvider.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    public static final Property airQualityEnabled = BNwsWeatherProvider.newProperty((int)0, (boolean)true, null);
    public static final Property forecastServer = BNwsWeatherProvider.newProperty((int)4, (String)"graphical.weather.gov", null);
    public static final Property forecastPath = BNwsWeatherProvider.newProperty((int)4, (String)"/xml/sample_products/browser_interface/ndfdBrowserClientByDay.php", null);
    public static final Property conditionsServer = BNwsWeatherProvider.newProperty((int)4, (String)"www.weather.gov", null);
    public static final Property conditionsPath = BNwsWeatherProvider.newProperty((int)4, (String)"/xml/current_obs/", null);
    public static final Property advisoriesServer = BNwsWeatherProvider.newProperty((int)4, (String)"alerts.weather.gov", null);
    public static final Property advisoriesPath = BNwsWeatherProvider.newProperty((int)4, (String)"/cap/", null);
    public static final Property airQualityHost = BNwsWeatherProvider.newProperty((int)4, (String)"www.airnowapi.org", null);
    public static final Property airQualityCurrentPath = BNwsWeatherProvider.newProperty((int)4, (String)"/aq/observation/zipCode/current/?format=application/xml&zipCode=", null);
    public static final Property airQualityForecastPath = BNwsWeatherProvider.newProperty((int)4, (String)"/aq/forecast/zipCode/?format=application/xml&zipCode=", null);
    public static final Property airQualityApiKeyField = BNwsWeatherProvider.newProperty((int)4, (String)"&API_KEY=", null);
    public static final Property advisoriesAlarmExt = BNwsWeatherProvider.newProperty((int)0, (BValue)new BNwsAdvisoryAlarmExt(), null);
    public static final Type TYPE = Sys.loadType(BNwsWeatherProvider.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weatherProvider.png");
    public static final int READ_TIMEOUT = AccessController.doPrivileged(() -> Integer.getInteger("weather.nws.readTimeout", 15000));
    public static final int CONNECT_TIMEOUT = AccessController.doPrivileged(() -> Integer.getInteger("weather.nws.connectTimeout", 15000));
    public static NwsStationList stationList = new NwsStationList();

    public String getStationId() {
        return this.getString(stationId);
    }

    public void setStationId(String v) {
        this.setString(stationId, v, null);
    }

    public int getOutlook() {
        return this.getInt(outlook);
    }

    public void setOutlook(int v) {
        this.setInt(outlook, v, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    public double getLongitude() {
        return this.getDouble(longitude);
    }

    public void setLongitude(double v) {
        this.setDouble(longitude, v, null);
    }

    public double getLatitude() {
        return this.getDouble(latitude);
    }

    public void setLatitude(double v) {
        this.setDouble(latitude, v, null);
    }

    public boolean getAirQualityEnabled() {
        return this.getBoolean(airQualityEnabled);
    }

    public void setAirQualityEnabled(boolean v) {
        this.setBoolean(airQualityEnabled, v, null);
    }

    public String getForecastServer() {
        return this.getString(forecastServer);
    }

    public void setForecastServer(String v) {
        this.setString(forecastServer, v, null);
    }

    public String getForecastPath() {
        return this.getString(forecastPath);
    }

    public void setForecastPath(String v) {
        this.setString(forecastPath, v, null);
    }

    public String getConditionsServer() {
        return this.getString(conditionsServer);
    }

    public void setConditionsServer(String v) {
        this.setString(conditionsServer, v, null);
    }

    public String getConditionsPath() {
        return this.getString(conditionsPath);
    }

    public void setConditionsPath(String v) {
        this.setString(conditionsPath, v, null);
    }

    public String getAdvisoriesServer() {
        return this.getString(advisoriesServer);
    }

    public void setAdvisoriesServer(String v) {
        this.setString(advisoriesServer, v, null);
    }

    public String getAdvisoriesPath() {
        return this.getString(advisoriesPath);
    }

    public void setAdvisoriesPath(String v) {
        this.setString(advisoriesPath, v, null);
    }

    public String getAirQualityHost() {
        return this.getString(airQualityHost);
    }

    public void setAirQualityHost(String v) {
        this.setString(airQualityHost, v, null);
    }

    public String getAirQualityCurrentPath() {
        return this.getString(airQualityCurrentPath);
    }

    public void setAirQualityCurrentPath(String v) {
        this.setString(airQualityCurrentPath, v, null);
    }

    public String getAirQualityForecastPath() {
        return this.getString(airQualityForecastPath);
    }

    public void setAirQualityForecastPath(String v) {
        this.setString(airQualityForecastPath, v, null);
    }

    public String getAirQualityApiKeyField() {
        return this.getString(airQualityApiKeyField);
    }

    public void setAirQualityApiKeyField(String v) {
        this.setString(airQualityApiKeyField, v, null);
    }

    public BNwsAdvisoryAlarmExt getAdvisoriesAlarmExt() {
        return (BNwsAdvisoryAlarmExt)this.get(advisoriesAlarmExt);
    }

    public void setAdvisoriesAlarmExt(BNwsAdvisoryAlarmExt v) {
        this.set(advisoriesAlarmExt, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void updateReport() {
        BForecast[] children;
        BWeatherReport report = (BWeatherReport)this.getParent();
        NwsStationList.Station station = stationList.getStation(this.getStationId());
        if (station == null) {
            BForecast[] children2;
            BWeatherService.log.log(Level.SEVERE, "Invalid weather station for " + report.getName());
            for (BForecast child : children2 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeFault((BStatus)child.getStatus(), (boolean)true));
            }
            report.getCurrent().setStatus(BStatus.makeFault((BStatus)report.getCurrent().getStatus(), (boolean)true));
            report.setStatus(BStatus.makeFault((BStatus)report.getStatus(), (boolean)true));
            return;
        }
        for (BForecast child : children = (BForecast[])report.getChildren(BForecast.class)) {
            child.setStatus(BStatus.makeFault((BStatus)child.getStatus(), (boolean)false));
        }
        report.getCurrent().setStatus(BStatus.makeFault((BStatus)report.getCurrent().getStatus(), (boolean)false));
        report.setStatus(BStatus.makeFault((BStatus)report.getStatus(), (boolean)false));
        this.setLongitude(station.longitude);
        this.setLatitude(station.latitude);
        try {
            try {
                BNwsAdvisoryAlarmExt alarmExt = this.getAdvisoriesAlarmExt();
                if (alarmExt.getEnabled()) {
                    alarmExt.getAdvisories(this, report.getCurrent(), station);
                }
                report.getCurrent().getAdvisories().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getAdvisories().getStatus(), (boolean)false));
            }
            catch (Exception e) {
                report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)true));
                BWeatherService.log.log(Level.WARNING, "Updating advisories failed for " + report.getName(), e);
                report.getCurrent().getAdvisories().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getAdvisories().getStatus(), (boolean)true));
            }
            NwsCurrentReader nwsCurrentReader = new NwsCurrentReader(this);
            nwsCurrentReader.getCurrent(this, report.getCurrent(), station);
            EpaCurrentReader epaCurrentReader = new EpaCurrentReader(this);
            epaCurrentReader.getCurrent(this, report.getCurrent(), station);
            boolean stale = !report.getCurrent().getObserved().isNull() && report.getCurrent().getObserved().isBefore(BAbsTime.now().subtract(BRelTime.makeHours((int)3)));
            report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)stale));
            if (BWeatherService.log.isLoggable(Level.FINE)) {
                BWeatherService.log.log(Level.FINE, "Updated current conditions for " + report.getName());
            }
        }
        catch (Exception e) {
            report.getCurrent().setStatus(BStatus.makeStale((BStatus)report.getCurrent().getStatus(), (boolean)true));
            BWeatherService.log.log(Level.WARNING, "Updating current conditions failed for " + report.getName(), e);
        }
        try {
            BForecast[] children3;
            NwsForecastReader nwsForecastReader = new NwsForecastReader(this);
            BForecast[] forecast = nwsForecastReader.getForecast(station, this.getOutlook());
            EpaForecastReader epaForecastReader = new EpaForecastReader(this);
            epaForecastReader.getForecast(station, forecast);
            report.setForecast(forecast);
            if (BWeatherService.log.isLoggable(Level.FINE)) {
                BWeatherService.log.log(Level.FINE, "Updated forecast for " + report.getName());
            }
            for (BForecast child : children3 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeStale((BStatus)child.getStatus(), (boolean)false));
            }
        }
        catch (Exception e) {
            BForecast[] children4;
            for (BForecast child : children4 = (BForecast[])report.getChildren(BForecast.class)) {
                child.setStatus(BStatus.makeStale((BStatus)child.getStatus(), (boolean)true));
            }
            BWeatherService.log.log(Level.WARNING, "Updating forecast failed for " + report.getName(), e);
        }
    }

    public String toString(Context context) {
        NwsStationList.Station station = stationList.getStation(this.getStationId());
        if (station != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(station.name);
            buf.append(", ").append(station.state);
            return buf.toString();
        }
        return this.getStationId();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(stationId)) {
            this.setLocation("");
            ((BWeatherReport)this.getParent()).updateWeatherReport();
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

