/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obixSeriesTransform;

import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BTransformGraph;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.QueryParams;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType(agent={@AgentOn(types={"seriesTransform:TransformGraph"}, requiredPermissions="r")})
@NiagaraSlots
public class BTransformGraphAgent
extends BComponent
implements BIObixAgent {
    public static final Type TYPE = Sys.loadType(BTransformGraphAgent.class);
    public static final String ATTR_IS = "is";
    private ObixEncoder encoder;
    private OrdTarget target;

    public Type getType() {
        return TYPE;
    }

    public boolean encode(OrdTarget target, ObixEncoder encoder) throws Exception {
        this.target = target;
        this.encoder = encoder;
        return true;
    }

    public void encodeFinishing() throws Exception {
        BTransformGraph tg = (BTransformGraph)this.getTarget().get();
        BSeriesTransformTable[] tableArray = tg.resolve((QueryParams)new NQueryParameters(), tg.getAbsoluteOrd(), (Context)BOrd.make((BOrd)tg.getAbsoluteOrd(), (OrdQuery)tg.getSlotPath()).resolve());
        if (tableArray != null) {
            BSeriesTransformTable table = tableArray[0];
            TableCursor c = table.cursor();
            BAbsTime start = BAbsTime.DEFAULT;
            BAbsTime end = BAbsTime.END_OF_TIME;
            int count = 0;
            if (c.next()) {
                start = BTransformGraphAgent.getTimestamp((BComplex)c.get(), BAbsTime.DEFAULT.getTimeZone());
                ++count;
                while (c.next()) {
                    ++count;
                }
                end = BTransformGraphAgent.getTimestamp((BComplex)c.get(), BAbsTime.DEFAULT.getTimeZone());
            }
            ObixEncoder out = this.getEncoder();
            String href = out.getHref();
            Obj obj = new Obj();
            obj.initInt("count", count);
            obj.write(out, false);
            obj.initAbstime("start", ObixUtils.dateTime((BAbsTime)start));
            obj.write(out, false);
            obj.initAbstime("end", ObixUtils.dateTime((BAbsTime)end));
            obj.write(out, false);
            obj.initOp("query", "/obix/def/obix:HistoryFilter", "/obix/def/obix:HistoryQueryOut");
            obj.setHref(out.getChildHref(href, "~historyQuery"));
            obj.write(out, false);
            obj.initOp("rollup", "/obix/def/obix:HistoryRollupIn", "/obix/def/obix:HistoryRollupOut");
            obj.setHref(out.getChildHref(href, "~historyRollup"));
            obj.setDisplay("Rollup is unsupported for this history");
            obj.write(out, false);
            obj.initFeed("feed", "/obix/def/obix:HistoryFilter", "/obix/def/obix:HistoryRecord");
            obj.setHref(out.getChildHref(href, "~historyFeed"));
            obj.setDisplay("Feed is unsupported for this history");
            obj.write(out, false);
            obj.initOp("append", "/obix/def/obix:HistoryAppendIn", "/obix/def/obix:HistoryAppendOut");
            obj.setHref(out.getChildHref(href, "~historyAppend"));
            obj.setDisplay("Append is unsupported for this history");
            obj.write(out, false);
        }
    }

    public ObixEncoder getEncoder() {
        return this.encoder;
    }

    public OrdTarget getTarget() {
        return this.target;
    }

    public String processAttr(String name, String value) {
        if (name.equals(ATTR_IS)) {
            return BIObixAgent.addToList((String)value, (String)"obix:History");
        }
        return value;
    }

    static QueryResults iterateQueryResults(ObixEncoder out, BSeriesTransformTable table, BInteger limit, OrdTarget tgt, BTimeZone tz) {
        return BTransformGraphAgent.iterateQueryResults(out, table, limit, tgt, BFacets.make((String)"TimeZone", (BIDataValue)tz));
    }

    static QueryResults iterateQueryResults(ObixEncoder out, BSeriesTransformTable table, BInteger limit, OrdTarget tgt, BFacets facets, BTimeZone tz) {
        return BTransformGraphAgent.iterateQueryResults(out, table, limit, tgt, facets);
    }

    static QueryResults iterateQueryResults(ObixEncoder out, BSeriesTransformTable table, BInteger limit, OrdTarget tgt, BFacets facets) {
        int count = 0;
        BAbsTime first = null;
        BAbsTime last = null;
        BTimeZone tz = BAbsTime.DEFAULT.getTimeZone();
        BSeriesSchema schema = table.getSchema();
        try {
            TableCursor cur = table.cursor();
            BComplex tableRec = null;
            int max = Integer.MAX_VALUE;
            if (limit != null) {
                max = limit.getInt();
            }
            if (cur.next()) {
                tableRec = (BComplex)cur.get();
            }
            if (tableRec != null) {
                BAbsTime time;
                first = time = (BAbsTime)BTransformGraphAgent.getTimestamp(tableRec, tz).newCopy(true).as(BAbsTime.class);
                tz = time.getTimeZone();
                last = first;
            }
            while (count < max && tableRec != null) {
                ++count;
                BAbsTime ts = BTransformGraphAgent.getTimestamp(tableRec, tz);
                if (last.isBefore(ts)) {
                    last = (BAbsTime)ts.newCopy(true).as(BAbsTime.class);
                }
                BTransformGraphAgent.encodeAsHistoryRecord(out, tableRec, schema, tz, tgt);
                out.commit();
                if (cur.next()) {
                    tableRec = (BComplex)cur.get();
                    continue;
                }
                tableRec = null;
            }
        }
        catch (Exception x) {
            out.encode((Throwable)x);
        }
        QueryResults ret = new QueryResults();
        ret.count = count;
        ret.first = first;
        ret.last = last;
        return ret;
    }

    private static BAbsTime getTimestamp(BComplex c, BTimeZone tz) {
        Property p = c.getProperty("timestamp");
        if (p != null && p.getType().is(BAbsTime.TYPE)) {
            return (BAbsTime)c.get(p).as(BAbsTime.class);
        }
        return null;
    }

    private static void encodeAsHistoryRecord(ObixEncoder out, BComplex tableRec, BSeriesSchema schema, BTimeZone tz, OrdTarget tgt) throws Exception {
        String[] fieldNames;
        Obj obj = new Obj();
        obj.setHref(out.getHref());
        if (out.getEncodeIs()) {
            obj.setIs("obix:HistoryRecord");
        }
        obj.write(out, true);
        boolean isContract = out.isContract();
        for (String fieldName : fieldNames = schema.getFieldNames()) {
            Property p = tableRec.getProperty(fieldName);
            if (p != null && p.getType().is(BSimple.TYPE)) {
                ObixUtils.encodeSimple((ObixEncoder)out, (Obj)obj.reset().setName(fieldName), (BSimple)tableRec.get(p).asSimple(), (Context)tgt);
            }
            if (isContract) {
                obj.setVal(null);
            }
            obj.write(out, false);
        }
        obj.reset().endElem(out);
    }

    static class QueryResults {
        int count;
        BAbsTime first;
        BAbsTime last;

        QueryResults() {
        }
    }
}

