/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obixSeriesTransform;

import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obixSeriesTransform.BTransformGraphAgent;
import com.tridium.seriestransform.NQueryParameters;
import com.tridium.seriestransform.graph.BTransformGraph;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.seriestransform.BSeriesTransformTable;
import javax.baja.seriestransform.graph.BSeriesSchema;
import javax.baja.seriestransform.graph.QueryParams;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraSlots
public class BObixTransformHistoryQuery
extends BObject
implements BIObixEncodable,
BIObixInvocable {
    public static final Type TYPE = Sys.loadType(BObixTransformHistoryQuery.class);
    BTransformGraph graph;
    String query;
    private static final Logger log = Logger.getLogger("obix.server");

    public Type getType() {
        return TYPE;
    }

    public BObixTransformHistoryQuery(BTransformGraph graph, OrdQuery query) {
        this.graph = graph;
        this.query = BObixTransformHistoryQuery.parseQuery(query);
    }

    public void encode(ObixEncoder out, Context cx) {
        if (this.query == null) {
            Obj obj = new Obj();
            obj.initOp("query", "obix:HistoryFilter", "obix:HistoryQueryOut");
            obj.setHref(out.getHref());
            obj.write(out, false);
        }
    }

    public void invoke(ObixDecoder in, ObixEncoder out) {
        BAbsTime end;
        BAbsTime start;
        BInteger limit;
        block19: {
            limit = BInteger.MAX;
            start = null;
            end = null;
            try {
                BComponent filter = (BComponent)in.decode();
                if (filter != null) {
                    limit = (BInteger)filter.get("limit");
                    start = (BAbsTime)filter.get("start");
                    end = (BAbsTime)filter.get("end");
                }
            }
            catch (Exception x) {
                if (!log.isLoggable(Level.FINER)) break block19;
                log.log(Level.FINER, "cannot parse history filter", x);
            }
        }
        try {
            if (this.graph == null) {
                throw new BadUriErr("SeriesTransform graph is null");
            }
            BSeriesTransformTable[] tableArray = this.graph.resolve((QueryParams)new NQueryParameters(), this.graph.getAbsoluteOrd(), (Context)BOrd.make((BOrd)this.graph.getAbsoluteOrd(), (OrdQuery)this.graph.getSlotPath()).resolve());
            Obj obj = new Obj().setIs("obix:HistoryQueryOut");
            obj.setHref(out.getHref());
            obj.write(out, true);
            obj.initList("data", "#RecordDef obix:HistoryRecord").write(out, true);
            out.commit();
            if (tableArray == null) {
                throw new BadUriErr("SeriesTransform data table is null");
            }
            if (log.isLoggable(Level.FINEST)) {
                for (int i = 0; i < tableArray.length; ++i) {
                    log.finest("\n\nTable " + i + ":");
                    BSeriesTransformTable table = tableArray[i];
                    ColumnList cl = table.getColumns();
                    this.printColumns(cl);
                    BSeriesSchema schema = table.getSchema();
                    this.printSlots((BComponent)schema);
                }
            }
            BSeriesTransformTable table = tableArray[0];
            OrdTarget base = this.graph.getOrdInSession().resolve(null, (Context)in);
            out.setName(null);
            out.setHref(null);
            out.setEncodeIs(false);
            String[] fieldNames = table.getSchema().getFieldNames();
            BSimple[] values = new BSimple[fieldNames.length];
            BFacets[] valuesFacets = new BFacets[fieldNames.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = table.getSchema().getFieldType(fieldNames[i]).getInstance().asSimple();
                valuesFacets[i] = table.getSchema().getFieldFacets(fieldNames[i]);
            }
            BAbsTime t = (BAbsTime)table.cursor().cell(table.getColumns().get(0)).as(BAbsTime.class);
            BTimeZone tz = t.getTimeZone();
            BTransformGraphAgent.QueryResults res = BTransformGraphAgent.iterateQueryResults(out, table, limit, base, null, tz);
            obj.initList(null, null).endElem(out);
            obj.initInt("count", res.count).write(out, false);
            if (res.first != null) {
                obj.initAbstime("start", res.first).write(out, false);
            } else if (start != null) {
                obj.initAbstime("start", BAbsTime.make((BAbsTime)start, (BTimeZone)tz)).write(out, false);
            }
            if (res.last != null) {
                obj.initAbstime("end", res.last).write(out, false);
            } else if (end != null) {
                obj.initAbstime("end", BAbsTime.make((BAbsTime)end, (BTimeZone)tz)).write(out, false);
            }
            BAbsTime def = res.first;
            if (def == null) {
                def = res.last;
            }
            if (def != null) {
                obj.reset().setHref("#RecordDef");
                out.setEncodeIs(true);
                out.setContract(true);
                obj.setIs("obix:HistoryRecord").write(out, true);
                for (int i = 0; i < values.length; ++i) {
                    ObixUtils.encodeSimple((ObixEncoder)out, (Obj)obj.reset().setName(fieldNames[i]), (BSimple)values[i], (Context)valuesFacets[i]);
                    obj.setVal(null).write(out, false);
                }
                obj.reset().endElem(out);
            }
            obj.reset().endElem(out);
        }
        catch (Exception e) {
            log.log(Level.FINE, "Exception invoking historyQuery on SeriesTransform graph", e);
            out.encode((Throwable)e);
        }
    }

    private static String parseQuery(OrdQuery oq) {
        String body = oq.getBody();
        int qMark = body.indexOf("?");
        return qMark < 0 ? null : body.substring(qMark + 1);
    }

    private void printSlots(BComponent c) {
        if (c == null) {
            System.out.println("null component");
            return;
        }
        System.out.println(c.getName() + " [" + c.getType() + "]");
        SlotCursor sc = c.getProperties();
        while (sc.next()) {
            Property p = sc.property();
            System.out.println("  " + p.getName() + ": " + sc.get() + " [" + p.getType() + "]");
        }
    }

    private void printColumns(ColumnList cl) {
        int sz = cl.size();
        for (int i = 0; i < sz; ++i) {
            Column col = cl.get(i);
            System.out.println("col " + i + ":" + col.getName() + " [" + col.getType() + "]");
        }
    }
}

