/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import java.util.Objects;
import javax.baja.gx.Geom;
import javax.baja.gx.IPolygonGeom;

public final class PolygonGeom
extends Geom
implements IPolygonGeom {
    private double[] x;
    private double[] y;
    private int size = 0;

    public PolygonGeom(IPolygonGeom polygon) {
        this.x = polygon.x();
        this.y = polygon.y();
        this.size = polygon.size();
    }

    public PolygonGeom(double[] x, double[] y, int size) {
        this.set(x, y, size);
    }

    public PolygonGeom() {
        this.x = new double[10];
        this.y = new double[10];
        this.size = 0;
    }

    @Override
    public int getGeomCase() {
        return 4;
    }

    @Override
    public double[] x() {
        return PolygonGeom.clone(this.x, this.size);
    }

    @Override
    public double[] y() {
        return PolygonGeom.clone(this.y, this.size);
    }

    @Override
    public double x(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.x[index];
    }

    @Override
    public double y(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.y[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public void add(double px, double py) {
        if (this.size >= this.x.length) {
            int newSize = Math.max(this.size * 2, 4);
            double[] tempx = new double[newSize];
            double[] tempy = new double[newSize];
            System.arraycopy(this.x, 0, tempx, 0, this.size);
            System.arraycopy(this.y, 0, tempy, 0, this.size);
            this.x = tempx;
            this.y = tempy;
        }
        this.x[this.size] = px;
        this.y[this.size] = py;
        ++this.size;
        this.dirty();
    }

    public void set(double[] x, double[] y, int size) {
        this.x = PolygonGeom.clone(x, size);
        this.y = PolygonGeom.clone(y, size);
        this.size = size;
        this.dirty();
    }

    public void clear() {
        this.size = 0;
        this.dirty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolygonGeom) {
            PolygonGeom p = (PolygonGeom)obj;
            if (this.size != p.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.x[i] == p.x[i] && this.y[i] == p.y[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.size);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            s.append(this.x[i]).append(',').append(this.y[i]).append(' ');
        }
        return s.toString();
    }

    private static double[] clone(double[] a, int size) {
        double[] c = new double[size];
        System.arraycopy(a, 0, c, 0, size);
        return c;
    }
}

