/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BTransform
extends BSimple {
    public static final int TRANSLATE = 1;
    public static final int SCALE = 2;
    public static final int ROTATE = 3;
    public static final int SKEW_X = 4;
    public static final int SKEW_Y = 5;
    public static final BTransform DEFAULT = BTransform.make(new Transform[0]);
    public static final Type TYPE = Sys.loadType(BTransform.class);
    Transform[] transforms;
    String string;
    BTransform inverse;
    Matrix matrix;
    Object awtSupport;

    public static BTransform make(Transform ... transforms) {
        return new BTransform(transforms);
    }

    public static BTransform make(Transform transform) {
        return new BTransform(transform);
    }

    public static BTransform makeTranslate(double x, double y) {
        return BTransform.make((Transform)new Translate(x, y));
    }

    public static BTransform makeScale(double x, double y) {
        return BTransform.make((Transform)new Scale(x, y));
    }

    public static BTransform makeRotate(double angle) {
        return BTransform.make((Transform)new Rotate(angle));
    }

    public static BTransform makeSkewX(double angle) {
        return BTransform.make((Transform)new SkewX(angle));
    }

    public static BTransform makeSkewY(double angle) {
        return BTransform.make((Transform)new SkewY(angle));
    }

    public static BTransform make(String s) {
        Parser parser = new Parser(s);
        BTransform x = parser.parseTransform();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BTransform(Transform[] transforms) {
        this.transforms = (Transform[])transforms.clone();
        this.calcMatrix();
    }

    private BTransform(Transform transform) {
        this.transforms = new Transform[]{transform};
        this.calcMatrix();
    }

    void calcMatrix() {
        if (this.transforms.length == 1) {
            this.matrix = this.transforms[0].toMatrix();
        } else {
            this.matrix = new Matrix();
            for (int i = 0; i < this.transforms.length; ++i) {
                this.matrix.multiply(this.transforms[i].toMatrix(), this.matrix);
            }
        }
    }

    public int size() {
        return this.transforms.length;
    }

    public Transform getTransform(int index) {
        return this.transforms[index];
    }

    public Transform[] getTransforms() {
        return (Transform[])this.transforms.clone();
    }

    public BTransform getInverse() {
        if (this.inverse == null) {
            Transform[] inverses = new Transform[this.transforms.length];
            for (int i = 0; i < inverses.length; ++i) {
                inverses[i] = this.transforms[this.transforms.length - i - 1].getInverse();
            }
            this.inverse = BTransform.make(inverses);
        }
        return this.inverse;
    }

    public Point transform(IPoint point, Point result) {
        if (result == null) {
            result = new Point();
        }
        return this.matrix.transform(point, result);
    }

    public int hashCode() {
        try {
            return this.encodeToString().hashCode();
        }
        catch (Throwable e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BTransform) {
            BTransform x = (BTransform)((Object)obj);
            if (this.transforms.length != x.transforms.length) {
                return false;
            }
            for (int i = 0; i < this.transforms.length; ++i) {
                if (this.transforms[i].equals(x.transforms[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.transforms.length == 1) {
                this.string = this.transforms[0].toString();
            } else {
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < this.transforms.length; ++i) {
                    if (i > 0) {
                        s.append(' ');
                    }
                    s.append(this.transforms[i]);
                }
                this.string = s.toString();
            }
        }
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BTransform.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    static class Matrix {
        double a = 1.0;
        double b;
        double c;
        double d = 1.0;
        double e;
        double f;

        Matrix() {
        }

        public Point transform(IPoint arg, Point result) {
            double x = arg.x();
            double y = arg.y();
            result.x = this.a * x + this.c * y + this.e;
            result.y = this.b * x + this.d * y + this.f;
            return result;
        }

        public Matrix multiply(Matrix arg, Matrix result) {
            double a = this.a;
            double b = this.b;
            double c = this.c;
            double d = this.d;
            double e = this.e;
            double f = this.f;
            double m = arg.a;
            double n = arg.b;
            double o = arg.c;
            double p = arg.d;
            double q = arg.e;
            double r = arg.f;
            result.a = a * m + c * n;
            result.c = a * o + c * p;
            result.e = a * q + c * r + e;
            result.b = b * m + d * n;
            result.d = b * o + d * p;
            result.f = b * q + d * r + f;
            return result;
        }
    }

    public static class SkewY
    extends Transform {
        double angle;

        public SkewY(double angle) {
            this.angle = angle;
        }

        @Override
        public int getTransformCase() {
            return 5;
        }

        public double getAngle() {
            return this.angle;
        }

        @Override
        Transform getInverse() {
            return new SkewY(-this.angle);
        }

        @Override
        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.b = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SkewY) {
                SkewY t = (SkewY)obj;
                return this.angle == t.angle;
            }
            return false;
        }

        public int hashCode() {
            return Double.hashCode(this.angle);
        }

        public String toString() {
            return "skewY(" + BDouble.encode((double)this.angle) + ')';
        }
    }

    public static class SkewX
    extends Transform {
        double angle;

        public SkewX(double angle) {
            this.angle = angle;
        }

        @Override
        public int getTransformCase() {
            return 4;
        }

        public double getAngle() {
            return this.angle;
        }

        @Override
        Transform getInverse() {
            return new SkewX(-this.angle);
        }

        @Override
        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.c = Math.tan(this.angle / 180.0 * Math.PI);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SkewX) {
                SkewX t = (SkewX)obj;
                return this.angle == t.angle;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.angle);
        }

        public String toString() {
            return "skewX(" + BDouble.encode((double)this.angle) + ')';
        }
    }

    public static class Rotate
    extends Transform {
        double angle;

        public Rotate(double angle) {
            this.angle = angle;
        }

        @Override
        public int getTransformCase() {
            return 3;
        }

        public double getAngle() {
            return this.angle;
        }

        @Override
        Transform getInverse() {
            return new Rotate(-this.angle);
        }

        @Override
        Matrix toMatrix() {
            double radians = this.angle / 180.0 * Math.PI;
            Matrix matrix = new Matrix();
            matrix.a = Math.cos(radians);
            matrix.b = Math.sin(radians);
            matrix.c = -Math.sin(radians);
            matrix.d = Math.cos(radians);
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Rotate) {
                Rotate t = (Rotate)obj;
                return this.angle == t.angle;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.angle);
        }

        public String toString() {
            return "rotate(" + BDouble.encode((double)this.angle) + ')';
        }
    }

    public static class Scale
    extends Transform {
        double x;
        double y;

        public Scale(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int getTransformCase() {
            return 2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        Transform getInverse() {
            return new Scale(1.0 / this.x, 1.0 / this.y);
        }

        @Override
        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.a = this.x;
            matrix.d = this.y;
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Scale) {
                Scale t = (Scale)obj;
                return this.x == t.x && this.y == t.y;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("scale(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                s.append(',').append(BDouble.encode((double)this.y));
            }
            s.append(')');
            return s.toString();
        }
    }

    public static class Translate
    extends Transform {
        double x;
        double y;

        public Translate(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int getTransformCase() {
            return 1;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        Transform getInverse() {
            return new Translate(-this.x, -this.y);
        }

        @Override
        Matrix toMatrix() {
            Matrix matrix = new Matrix();
            matrix.e = this.x;
            matrix.f = this.y;
            return matrix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Translate) {
                Translate t = (Translate)obj;
                return this.x == t.x && this.y == t.y;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("translate(").append(BDouble.encode((double)this.x));
            if (this.y != 0.0) {
                s.append(',').append(BDouble.encode((double)this.y));
            }
            s.append(')');
            return s.toString();
        }
    }

    public static abstract class Transform {
        public abstract int getTransformCase();

        abstract Transform getInverse();

        abstract Matrix toMatrix();
    }
}

