/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.IOException;
import javax.baja.gx.BGeom;
import javax.baja.gx.IPolygonGeom;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPolygonGeom
extends BGeom
implements IPolygonGeom {
    public static final BPolygonGeom DEFAULT = new BPolygonGeom(new double[0], new double[0], 0);
    public static final BPolygonGeom NULL = new BPolygonGeom(new double[0], new double[0], 0);
    public static final Type TYPE = Sys.loadType(BPolygonGeom.class);
    private double[] x;
    private double[] y;
    private int size;

    public static BPolygonGeom make(IPolygonGeom polygon) {
        if (polygon instanceof BPolygonGeom) {
            return (BPolygonGeom)polygon;
        }
        return new BPolygonGeom(polygon.x(), polygon.y(), polygon.size());
    }

    public static BPolygonGeom make(double[] x, double[] y) {
        return BPolygonGeom.make(x, y, x.length);
    }

    public static BPolygonGeom make(double[] x, double[] y, int size) {
        return new BPolygonGeom(BPolygonGeom.clone(x, size), BPolygonGeom.clone(y, size), size);
    }

    public static BPolygonGeom make(String s) {
        Parser parser = new Parser(s);
        BPolygonGeom x = parser.parsePolygon();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BPolygonGeom(double[] x, double[] y, int size) {
        this.x = x;
        this.y = y;
        this.size = size;
    }

    @Override
    public int getGeomCase() {
        return 4;
    }

    @Override
    public double[] x() {
        return BPolygonGeom.clone(this.x, this.size);
    }

    @Override
    public double[] y() {
        return BPolygonGeom.clone(this.y, this.size);
    }

    @Override
    public double x(int index) {
        return this.x[index];
    }

    @Override
    public double y(int index) {
        return this.y[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        int len = this.size();
        long hash = 23L + (long)len;
        for (int i = 0; i < len; ++i) {
            hash = hash * 37L + Double.doubleToRawLongBits(this.x[i]);
            hash = hash * 37L + Double.doubleToRawLongBits(this.y[i]);
        }
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BPolygonGeom) {
            BPolygonGeom p = (BPolygonGeom)obj;
            int size = this.size();
            if (size != p.size()) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (this.x[i] == p.x[i] && this.y[i] == p.y[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            s.append(this.x[i]).append(',').append(this.y[i]).append(' ');
        }
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return BPolygonGeom.make(s);
    }

    private static double[] clone(double[] a, int size) {
        double[] c = new double[size];
        System.arraycopy(a, 0, c, 0, size);
        return c;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

