/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.IPoint;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BPoint
extends BSimple
implements IPoint {
    public static final BPoint DEFAULT = new BPoint(0.0, 0.0);
    public static final BPoint NULL = new BPoint(0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BPoint.class);
    public final double x;
    public final double y;

    public static BPoint make(double x, double y) {
        return new BPoint(x, y);
    }

    public static BPoint make(IPoint pt) {
        return BPoint.make(pt.x(), pt.y());
    }

    private BPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.x);
        hash = hash * 37L + Double.doubleToRawLongBits(this.y);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BPoint) {
            BPoint p = (BPoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.x).append(',').append(this.y);
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.equals("null")) {
            return NULL;
        }
        int comma = s.indexOf(44);
        return BPoint.make(BDouble.decode((String)s.substring(0, comma)), BDouble.decode((String)s.substring(comma + 1)));
    }

    public Type getType() {
        return TYPE;
    }
}

