/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.gx.IInsets;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BInsets
extends BSimple
implements IInsets {
    public static final BInsets DEFAULT = new BInsets(0.0, 0.0, 0.0, 0.0);
    public static final BInsets NULL = new BInsets(0.0, 0.0, 0.0, 0.0);
    public static final Type TYPE = Sys.loadType(BInsets.class);
    public final double top;
    public final double right;
    public final double bottom;
    public final double left;

    public static BInsets make(double top, double right, double bottom, double left) {
        return new BInsets(top, right, bottom, left);
    }

    public static BInsets make(double side) {
        return new BInsets(side, side, side, side);
    }

    public static BInsets make(IInsets i) {
        if (i instanceof BInsets) {
            return (BInsets)i;
        }
        return BInsets.make(i.top(), i.right(), i.bottom(), i.left());
    }

    public static BInsets make(String s) {
        Parser parser = new Parser(s);
        BInsets x = parser.parseInsets();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    private BInsets(double top, double right, double bottom, double left) {
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    @Override
    public double top() {
        return this.top;
    }

    @Override
    public double right() {
        return this.right;
    }

    @Override
    public double bottom() {
        return this.bottom;
    }

    @Override
    public double left() {
        return this.left;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        long hash = 23L + Double.doubleToRawLongBits(this.top);
        hash = hash * 37L + Double.doubleToRawLongBits(this.bottom);
        hash = hash * 37L + Double.doubleToRawLongBits(this.left);
        hash = hash * 37L + Double.doubleToRawLongBits(this.right);
        return (int)(hash >>> 32) ^ (int)hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BInsets) {
            BInsets i = (BInsets)obj;
            return this.top == i.top && this.bottom == i.bottom && this.left == i.left && this.right == i.right;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "null";
        }
        if (this.top == this.bottom && this.left == this.right) {
            if (this.top == this.right) {
                return BDouble.encode((double)this.top);
            }
            return BDouble.encode((double)this.top) + ' ' + BDouble.encode((double)this.right);
        }
        return BDouble.encode((double)this.top) + ' ' + BDouble.encode((double)this.right) + ' ' + BDouble.encode((double)this.bottom) + ' ' + BDouble.encode((double)this.left);
    }

    public BObject decodeFromString(String s) throws IOException {
        return BInsets.make(s);
    }

    public Type getType() {
        return TYPE;
    }
}

