/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BFont
extends BSimple {
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int UNDERLINE = 4;
    private static Hashtable<String, BFont> cache = new Hashtable();
    public static final BFont DEFAULT = BFont.make("sans-serif", 12.0);
    public static final BFont NULL = new BFont("null", 0.0, 0, "null");
    public static final Type TYPE;
    private String name;
    private double size;
    private int style;
    private boolean antiAliased = true;
    private String string;
    private FontPeer peer;
    private Object awtSupport;

    public static BFont make(String name, double size) {
        return BFont.make(name, size, 0);
    }

    public static BFont make(String name, double size, int style) {
        if (name == null || (style & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer s = new StringBuffer();
        if ((style & 1) != 0) {
            s.append("bold ");
        }
        if ((style & 2) != 0) {
            s.append("italic ");
        }
        if ((style & 4) != 0) {
            s.append("underline ");
        }
        s.append(BDouble.encode((double)size)).append("pt ");
        s.append(name);
        String string = s.toString();
        BFont font = cache.get(string);
        if (font == null) {
            font = new BFont(name, size, style, string);
            cache.put(string, font);
        }
        return font;
    }

    public static BFont make(String s) {
        Parser parser = new Parser(s);
        BFont x = parser.parseFont();
        if (x == null || !parser.isEnd()) {
            throw new IllegalArgumentException(s);
        }
        return x;
    }

    public static BFont make(BFont font, int style) {
        return BFont.make(font.getName(), font.getSize(), style);
    }

    public static BFont make(BFont font, double size) {
        return BFont.make(font.getName(), size, font.getStyle());
    }

    private BFont(String name, double size, int style, String string) {
        this.name = name;
        this.size = size;
        this.style = style;
        this.string = string;
        this.antiAliased = true;
    }

    public String getName() {
        return this.name;
    }

    public double getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isUnderline() {
        return (this.style & 4) != 0;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public double getLeading() {
        return this.peer().getLeading();
    }

    public double getAscent() {
        return this.peer().getAscent();
    }

    public double getDescent() {
        return this.peer().getDescent();
    }

    public double getHeight() {
        return this.peer().getHeight();
    }

    public double getMaxAscent() {
        return this.peer().getMaxAscent();
    }

    public double getMaxDescent() {
        return this.peer().getMaxDescent();
    }

    public double width(int c) {
        return this.peer().width(c);
    }

    public double width(String s) {
        if (null == s) {
            return 0.0;
        }
        return this.peer().width(s);
    }

    public double width(char[] data, int off, int len) {
        return this.peer().width(data, off, len);
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BFont) {
            return this.string.equals(((BFont)((Object)obj)).string);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        return this.string;
    }

    public BObject decodeFromString(String s) throws IOException {
        return BFont.make(s);
    }

    public Type getType() {
        return TYPE;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 201: {
                return this.awtSupport;
            }
            case 202: {
                this.awtSupport = a;
                return null;
            }
            case 206: {
                return this.peer();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    FontPeer peer() {
        if (this.peer == null) {
            this.peer = GxEnv.get().makeFontPeer(this);
        }
        return this.peer;
    }

    static {
        cache.put("null", NULL);
        TYPE = Sys.loadType(BFont.class);
    }
}

