/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.parser;

public class Token {
    public static final int UNKNOWN = 0;
    public static final int DOT = 1;
    public static final int COMMA = 2;
    public static final int SEMICOLON = 3;
    public static final int COLON = 4;
    public static final int LBRACE = 5;
    public static final int RBRACE = 6;
    public static final int LPAREN = 7;
    public static final int RPAREN = 8;
    public static final int LBRACKET = 9;
    public static final int RBRACKET = 10;
    public static final int SLASH = 11;
    public static final int STAR = 12;
    public static final int PLUS = 13;
    public static final int EQ = 14;
    public static final int ID = 15;
    public static final int STRING = 16;
    public static final int HASH = 17;
    public static final int FUNCTION = 18;
    public static final int NUM = 19;
    public static final int DIMEN = 20;
    public static final int PATHCMD = 21;
    public static final int EOF = 22;
    public static final String[] TYPES = new String[]{"unknown", ".", ",", ";", ":", "{", "}", "(", ")", "[", "]", "/", "*", "+", "=", "id", "string", "hash", "function", "num", "dimen", "pathcmd", "eof"};
    public int type;
    public double num;
    public String str;
    public int pathcmd;
    public int pos;

    public boolean num() {
        return this.type == 19;
    }

    public boolean id(String s) {
        return this.type == 15 && this.str.equals(s);
    }

    public boolean function(String s) {
        return this.type == 18 && this.str.equals(s);
    }

    public boolean dimen(String s) {
        return this.type == 20 && this.str.equals(s);
    }

    public Token set(int type) {
        this.type = type;
        this.num = 0.0;
        this.str = "";
        return this;
    }

    public Token copy() {
        return new Token().copy(this);
    }

    public Token copy(Token from) {
        this.type = from.type;
        this.num = from.num;
        this.str = from.str;
        this.pos = from.pos;
        this.pathcmd = from.pathcmd;
        return this;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return '?' + this.str + '?';
            }
            case 15: {
                return this.str;
            }
            case 16: {
                return '\"' + Token.escape(this.str) + '\"';
            }
            case 17: {
                return '#' + this.str;
            }
            case 18: {
                return this.str + "(";
            }
            case 19: {
                return "" + this.num;
            }
            case 20: {
                return "" + this.num + this.str;
            }
            case 21: {
                return "" + (char)this.pathcmd;
            }
        }
        return TYPES[this.type];
    }

    public static String escape(String s) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (' ' <= c && c <= '\u007f') {
                buf.append(c);
                continue;
            }
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            buf.append("\\" + Integer.toHexString(c) + ";");
        }
        return buf.toString();
    }
}

