/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GeomPeer;
import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnvListener;
import com.tridium.gx.Hatching;
import com.tridium.gx.ImagePeer;
import java.io.InputStream;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IGeom;
import javax.baja.sys.Sys;

public abstract class GxEnv {
    private static GxEnv env;
    private static final boolean FORCE_MICRO;
    private static final boolean FORCE_MICRO_STATION;
    GxEnvListener listener;
    private static final Logger LOG;

    public static GxEnv get() {
        if (env == null) {
            boolean forceMicro;
            boolean bl = forceMicro = FORCE_MICRO || FORCE_MICRO_STATION && Sys.getStation() != null;
            if (!forceMicro) {
                try {
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.awt.se.AwtSeEnv");
                }
                catch (Throwable throwable) {
                    LOG.log(Level.FINE, "Unable to instantiate AwtSeEnv", throwable);
                }
            }
            if (env == null) {
                try {
                    if (forceMicro) {
                        LOG.log(Level.FINE, "Forcing gx MicroEnv");
                    }
                    env = (GxEnv)Sys.newInstance((String)"gx", (String)"com.tridium.gx.micro.MicroEnv");
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Cannot load gx:MicroEnv", e);
                }
            }
            if (env == null) {
                throw new IllegalStateException("No GxEnv available for VM");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "GxEnv: " + env.getClass());
            }
        }
        return env;
    }

    public abstract boolean isRotationSupported();

    public abstract FontPeer makeFontPeer(BFont var1);

    public abstract GeomPeer makeGeomPeer(IGeom var1);

    public abstract ImagePeer makeImagePeer(BImage var1);

    public abstract BImage makeImage(double var1, double var3);

    public abstract BImage makeImage(byte[] var1);

    public BImage makeDisabled(BImage orig) {
        return orig;
    }

    public BImage makeHighlighted(BImage orig) {
        return orig;
    }

    public GxEnvListener getGxEnvListener() {
        return this.listener;
    }

    public void setGxEnvListener(GxEnvListener listener) {
        if (this.listener != null) {
            LOG.warning("GxEnv setGxEnvListener: " + this.listener);
        }
        this.listener = listener;
    }

    public void repaintAll() {
        try {
            if (this.listener != null) {
                this.listener.repaintAll();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public GraphPaper makeGraphPaper() {
        throw new UnsupportedOperationException("GraphPaper not supported.");
    }

    public Hatching makeHatching() {
        throw new UnsupportedOperationException("Hatching not supported.");
    }

    public void loadFont(InputStream in) {
    }

    public String getValidFontName(String fontList) {
        return null;
    }

    public boolean hasFont(String fontName) {
        return false;
    }

    public void overrideFontFamily(String fontFamily, String valueName) {
    }

    static {
        FORCE_MICRO = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.env.forceMicro"));
        FORCE_MICRO_STATION = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.ui.env.forceMicroStation"));
        LOG = Logger.getLogger("gx");
    }
}

