/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.ui;

import com.tridium.ddfIp.comm.BDdfIpAdapter;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BDdfIpAdapterEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BDdfIpAdapterEditor.class);
    protected BDdfIpAdapter ipAdapter = null;
    public static final Lexicon LEX = Lexicon.make(BDdfIpAdapterEditor.class);
    public static final String IP_ADAPTER_KEY = "Adapter";
    public static final String IP_ADAPTER_TEXT = LEX.getText("Adapter");
    public static final String DEFAULT_LOCAL_HOST_KEY = "DefaultLocalHost";
    public static final String DEFAULT_LOCAL_HOST_TEXT = "[*** " + LEX.getText("DefaultLocalHost") + " ***]";
    protected BTextDropDown adapterDropDown = null;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.ipAdapter = (BDdfIpAdapter)value;
        this.layoutUi();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BDdfIpAdapter saveValue = (BDdfIpAdapter)value;
        int selectedAdapterPosition = this.adapterDropDown.getList().getSelectedIndex();
        if (selectedAdapterPosition < 0) {
            saveValue.becomeDescriptionOnlyAdapter(this.adapterDropDown.getText());
        } else if (selectedAdapterPosition == 0) {
            saveValue.becomeDefaultLocalHostAdapter();
        } else {
            AdapterDropDownListItem selectedItem = (AdapterDropDownListItem)this.adapterDropDown.getList().getSelectedItem();
            saveValue.setDescription(selectedItem.description);
            saveValue.setAdapterId(selectedItem.adapterId);
            saveValue.setIpAddress(selectedItem.ipAddress);
        }
        return saveValue;
    }

    protected BTextDropDown makeAdapterDropDown() {
        BTextField textField = new BTextField();
        BList list = new BList();
        AdapterDropDownListItem defaultListItem = new AdapterDropDownListItem(DEFAULT_LOCAL_HOST_TEXT, "", "");
        list.addItem((Object)defaultListItem);
        list.setSelectedItem((Object)defaultListItem);
        int widestTextItem = DEFAULT_LOCAL_HOST_TEXT.length();
        BVector hostIpAdapters = this.getIpCommunicator().refreshHostIpAdapters();
        BDdfIpAdapter[] hostEthernetAdapters = (BDdfIpAdapter[])hostIpAdapters.getChildren(BDdfIpAdapter.class);
        for (int i = 0; i < hostEthernetAdapters.length; ++i) {
            AdapterDropDownListItem listItem = new AdapterDropDownListItem(hostEthernetAdapters[i].getDescription(), hostEthernetAdapters[i].getAdapterId(), hostEthernetAdapters[i].getIpAddress());
            list.addItem((Object)listItem);
            if (this.ipAdapter.getDescription().equals(listItem.description) && this.ipAdapter.getAdapterId().equals(listItem.adapterId) && this.ipAdapter.getIpAddress().equals(listItem.ipAddress)) {
                list.setSelectedItem((Object)listItem);
            }
            if (listItem.toString().length() <= widestTextItem) continue;
            widestTextItem = listItem.toString().length();
        }
        if (this.ipAdapter.isDescriptionOnlyAdapter()) {
            textField.setText(this.ipAdapter.getDescription());
            list.setSelectedIndex(-1);
            if (this.ipAdapter.getDescription().length() > widestTextItem) {
                widestTextItem = this.ipAdapter.getDescription().toString().length();
            }
        } else {
            textField.setText(list.getSelectedItem().toString());
        }
        BTextDropDown textDropDown = new BTextDropDown();
        for (int i = 0; i < list.getItemCount(); ++i) {
            textDropDown.getList().addItem(list.getItem(i));
        }
        textDropDown.setText(textField.getText());
        textDropDown.getEditor().setEditable(hostEthernetAdapters.length == 0);
        textDropDown.getEditor().setVisibleColumns(widestTextItem + 5 > 50 ? 50 : widestTextItem + 5);
        return textDropDown;
    }

    protected void layoutUi() {
        this.adapterDropDown = this.makeAdapterDropDown();
        this.setContent((BWidget)this.adapterDropDown);
        this.linkTo((BComponent)this.adapterDropDown, (Slot)BTextDropDown.valueModified, (Slot)BWbEditor.setModified);
    }

    protected BDdfIpCommunicator getIpCommunicator() {
        BDdfIpAdapter p;
        for (p = this.ipAdapter; !(p instanceof BDdfIpCommunicator) && p != null; p = p.getParent()) {
        }
        return (BDdfIpCommunicator)p;
    }

    public static class AdapterDropDownListItem {
        public final String description;
        public final String adapterId;
        public final String ipAddress;

        AdapterDropDownListItem(String desc, String id, String ipAddr) {
            this.description = desc;
            this.adapterId = id;
            this.ipAddress = ipAddr;
        }

        public String toString() {
            return this.description;
        }
    }
}

