/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.retention;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceJobPrototype;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BIRetainable;
import javax.baja.retention.BIRetentionPolicyDomain;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSlots
public final class BKeepNPerDeviceRetentionPolicy
extends BRetentionPolicy
implements BIDomainRetentionPolicy {
    public static final BKeepNPerDeviceRetentionPolicy DEFAULT = new BKeepNPerDeviceRetentionPolicy();
    public static final Type TYPE = Sys.loadType(BKeepNPerDeviceRetentionPolicy.class);
    private final int successfulRetentionLimit;
    private final int unsuccessfulRetentionLimit;
    public static final Comparator<? super BDeviceNetworkJob> DESCENDING_START_TIME = Comparator.comparing(j -> j.getStartTime().getMillis()).reversed();

    @Override
    public Type getType() {
        return TYPE;
    }

    public BKeepNPerDeviceRetentionPolicy() {
        this.successfulRetentionLimit = 5;
        this.unsuccessfulRetentionLimit = 1;
    }

    public BKeepNPerDeviceRetentionPolicy(int successfulRetentionLimit, int unsuccessfulRetentionLimit) {
        this.successfulRetentionLimit = successfulRetentionLimit;
        this.unsuccessfulRetentionLimit = unsuccessfulRetentionLimit;
    }

    public int getSuccessfulRetentionLimit() {
        return this.successfulRetentionLimit;
    }

    public int getUnsuccessfulRetentionLimit() {
        return this.unsuccessfulRetentionLimit;
    }

    @Override
    public Type[] getApplicableDomainTypes() {
        return new Type[]{BDeviceJobPrototype.TYPE};
    }

    @Override
    public void executePolicy(BIRetentionPolicyDomain domain) {
        HashMap<BSimple, TreeSet<? super BDeviceNetworkJob>> successfulByDeviceId = new HashMap<BSimple, TreeSet<? super BDeviceNetworkJob>>();
        HashMap unsuccessfulByDeviceId = new HashMap();
        TreeSet<? super BDeviceNetworkJob> jobsToDispose = new TreeSet<BDeviceNetworkJob>(DESCENDING_START_TIME);
        block0: for (BIRetainable retainable : domain.getRetainables()) {
            BDeviceNetworkJob job;
            if (!(retainable instanceof BDeviceNetworkJob) || !(job = (BDeviceNetworkJob)retainable).getJobState().isComplete()) continue;
            jobsToDispose.add(job);
            for (BJobStepDetails jobStepDetails : job.getJobStepDetails()) {
                if (!jobStepDetails.getState().isComplete()) {
                    jobsToDispose.remove(job);
                    continue block0;
                }
                BDeviceStepDetails deviceStepDetails = (BDeviceStepDetails)jobStepDetails;
                HashMap<Object, TreeSet<BDeviceNetworkJob>> mapToUpdate = deviceStepDetails.getState() == BJobState.success ? successfulByDeviceId : unsuccessfulByDeviceId;
                TreeSet<? super BDeviceNetworkJob> jobs = (TreeSet<? super BDeviceNetworkJob>)mapToUpdate.get(deviceStepDetails.getDeviceId());
                if (jobs == null) {
                    jobs = new TreeSet<BDeviceNetworkJob>(DESCENDING_START_TIME);
                    mapToUpdate.put(deviceStepDetails.getDeviceId(), jobs);
                }
                jobs.add(job);
            }
        }
        block2: for (BSimple deviceId : successfulByDeviceId.keySet()) {
            int i = 0;
            for (BDeviceNetworkJob job : (Set)successfulByDeviceId.get(deviceId)) {
                if (i >= this.successfulRetentionLimit) continue block2;
                jobsToDispose.remove(job);
                ++i;
            }
        }
        block4: for (BSimple deviceId : unsuccessfulByDeviceId.keySet()) {
            int i = 0;
            for (BDeviceNetworkJob job : (Set)unsuccessfulByDeviceId.get(deviceId)) {
                if (i >= this.unsuccessfulRetentionLimit) continue block4;
                jobsToDispose.remove(job);
                ++i;
            }
        }
        jobsToDispose.forEach(BJob::dispose);
    }

    @Override
    public Type[] getApplicableRetainableTypes() {
        return new Type[]{BDeviceNetworkJob.TYPE};
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BKeepNPerDeviceRetentionPolicy)) {
            return false;
        }
        BKeepNPerDeviceRetentionPolicy policy = (BKeepNPerDeviceRetentionPolicy)obj;
        return policy.successfulRetentionLimit == this.successfulRetentionLimit && policy.unsuccessfulRetentionLimit == this.unsuccessfulRetentionLimit;
    }

    public int hashCode() {
        return Objects.hash(this.successfulRetentionLimit, this.unsuccessfulRetentionLimit);
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public String encodeToString() throws IOException {
        return String.join((CharSequence)",", String.valueOf(this.successfulRetentionLimit), String.valueOf(this.unsuccessfulRetentionLimit));
    }

    public BObject decodeFromString(String s) throws IOException {
        String[] tokens = s.split(",");
        return new BKeepNPerDeviceRetentionPolicy(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
    }

    public String toString(Context cx) {
        return Lexicon.make((String)"batchJob", (Context)cx).getText("KeepNPerDeviceRetentionPolicy.displayText", new Object[]{this.successfulRetentionLimit, this.unsuccessfulRetentionLimit});
    }
}

