/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import javax.baja.agent.AgentFilter;
import javax.baja.agent.BIAgent;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNetworkBatchAgent
extends BSingleton
implements BIAgent {
    public static final BNetworkBatchAgent INSTANCE = new BNetworkBatchAgent();
    public static final Type TYPE = Sys.loadType(BNetworkBatchAgent.class);

    public Type getType() {
        return TYPE;
    }

    public static BNetworkBatchAgent get(BDeviceNetwork nw, Context cx) {
        return (BNetworkBatchAgent)nw.getAgents(cx).filter(AgentFilter.is((Type)TYPE)).getDefault().getInstance();
    }

    public static BNetworkBatchAgent get(BDevice device) {
        return BNetworkBatchAgent.get(device.getNetworkType());
    }

    public static BNetworkBatchAgent get(Type nwType) {
        return (BNetworkBatchAgent)Sys.getRegistry().getAgents(nwType.getTypeInfo()).filter(AgentFilter.is((Type)TYPE)).getDefault().getInstance();
    }

    public BDevice[] listBatchDevices(BDeviceNetwork nw) throws Exception {
        return nw.getDevices();
    }

    public boolean isBatchDevice(BDevice device) {
        return true;
    }

    public BSimple getBatchDeviceId(BDevice device) {
        return BString.make((String)device.getName());
    }

    public BDeviceNetwork getDeviceNetwork(BDevice device) {
        return device.getNetwork();
    }

    public BDevice getBatchDevice(BDeviceNetwork nw, BSimple id) {
        BITable table = (BITable)BOrd.make((String)("bql:select slotPath from " + nw.getDeviceType().toString() + " where name ='" + id.toString() + '\'')).get((BObject)nw);
        try (TableCursor c = table.cursor();){
            if (c.next()) {
                BDevice bDevice = (BDevice)BOrd.make((String)c.cell(table.getColumns().get(0)).toString()).get((BObject)nw);
                return bDevice;
            }
            BDevice bDevice = null;
            return bDevice;
        }
    }

    public BDevice getBatchDevice(BObject base, TypeInfo networkType, BSimple id) {
        try {
            BDeviceNetwork network = (BDeviceNetwork)BOrd.make((String)("service:" + networkType.toString())).get(base);
            BDevice[] devices = this.listBatchDevices(network);
            if (devices.length == 0) {
                return null;
            }
            for (BDevice device : devices) {
                if (!device.getName().equals(id.toString())) continue;
                return device;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

