/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.BatchJobTask;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLogItem;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="steps", type="baja:Folder", defaultValue="new BFolder()", flags=1), @NiagaraProperty(name="deviceStates", type="baja:Folder", defaultValue="new BFolder()", flags=1), @NiagaraProperty(name="runDevicesInParallel", type="baja:Boolean", defaultValue="BBoolean.TRUE"), @NiagaraProperty(name="forceUnsafeParallelExecution", type="baja:Boolean", defaultValue="BBoolean.FALSE")}, actions={@NiagaraAction(name="cancelDevice", parameterType="baja:Simple", defaultValue="BString.DEFAULT", flags=4)})
public class BForEachDeviceStage
extends BJobStage {
    public static final Property steps = BForEachDeviceStage.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property deviceStates = BForEachDeviceStage.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property runDevicesInParallel = BForEachDeviceStage.newProperty((int)0, (boolean)BBoolean.TRUE.getBoolean(), null);
    public static final Property forceUnsafeParallelExecution = BForEachDeviceStage.newProperty((int)0, (boolean)BBoolean.FALSE.getBoolean(), null);
    public static final Action cancelDevice = BForEachDeviceStage.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BForEachDeviceStage.class);
    private static final Logger logger = Logger.getLogger("batchJob.forEachDeviceStage");

    public BFolder getSteps() {
        return (BFolder)this.get(steps);
    }

    public void setSteps(BFolder v) {
        this.set(steps, (BValue)v, null);
    }

    public BFolder getDeviceStates() {
        return (BFolder)this.get(deviceStates);
    }

    public void setDeviceStates(BFolder v) {
        this.set(deviceStates, (BValue)v, null);
    }

    public boolean getRunDevicesInParallel() {
        return this.getBoolean(runDevicesInParallel);
    }

    public void setRunDevicesInParallel(boolean v) {
        this.setBoolean(runDevicesInParallel, v, null);
    }

    public boolean getForceUnsafeParallelExecution() {
        return this.getBoolean(forceUnsafeParallelExecution);
    }

    public void setForceUnsafeParallelExecution(boolean v) {
        this.setBoolean(forceUnsafeParallelExecution, v, null);
    }

    public void cancelDevice(BSimple parameter) {
        this.invoke(cancelDevice, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BForEachDeviceStage() {
    }

    public BForEachDeviceStage(String stageName) {
        super(stageName);
    }

    public BJobState getDeviceState(BSimple deviceId) {
        try {
            String slotName = SlotPath.escape((String)deviceId.encodeToString());
            Property prop = this.getDeviceStates().getProperty(slotName);
            return prop == null ? BJobState.unknown : (BJobState)this.getDeviceStates().get(prop);
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BJobState getDeviceState(BDevice device) {
        return this.getDeviceState(this.getDeviceId(device));
    }

    protected BSimple getDeviceId(BDevice device) {
        return BNetworkBatchAgent.get(this.getNetwork(), null).getBatchDeviceId(device);
    }

    public void setDeviceState(BDevice device, BJobState value) {
        this.setDeviceState(this.getDeviceId(device), value);
    }

    public void setDeviceState(BSimple deviceId, BJobState value) {
        try {
            String slotName = SlotPath.escape((String)deviceId.encodeToString());
            Property prop = this.getDeviceStates().getProperty(slotName);
            if (prop == null) {
                this.getDeviceStates().add(slotName, (BValue)value);
            } else {
                this.getDeviceStates().set(prop, (BValue)value);
            }
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BDevice[] getDevices() {
        return ((BDeviceNetworkJob)this.getJob()).getDevices();
    }

    public BDeviceNetwork getNetwork() {
        return ((BDeviceNetworkJob)this.getJob()).getNetwork();
    }

    public boolean canPassDefaultCheck(BDevice device, BDeviceJobStep step) {
        return true;
    }

    @Override
    public BJobState doRun(BBatchJobService service, BBatchJob job, BatchJobOp opIn) {
        DeviceNetworkJobOp op = (DeviceNetworkJobOp)opIn;
        BDeviceJobStep[] steps = this.getCombinedSteps(op);
        BDevice[] devices = this.getDevices();
        for (BDeviceJobStep step : steps) {
            try {
                step.doInit(service, op);
            }
            catch (Exception e) {
                this.getJob().log().failed("batchJob", "ForEachDeviceStage.initializationFailed", (Throwable)e);
                return BJobState.failed;
            }
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getRunDevicesInParallel()) {
            if (this.getForceUnsafeParallelExecution()) {
                logger.info("Executing all BatchJob steps in parallel");
                return this.executeParallel(service, op, steps, devices);
            }
            logger.info("Executing parallel safe BatchJob steps in parallel");
            return this.safeExecuteParallel(service, op, steps, devices);
        }
        logger.info("Executing BatchJob steps sequentially");
        return this.executeSequential(service, op, steps, devices);
    }

    private BJobState safeExecuteParallel(BBatchJobService service, DeviceNetworkJobOp op, BDeviceJobStep[] steps, BDevice[] devices) {
        HashSet<BDevice> allDevices = new HashSet<BDevice>(Arrays.asList(devices));
        ArrayList<BDeviceJobStep> parallelSafeSteps = new ArrayList<BDeviceJobStep>();
        BJobState jobState = BJobState.success;
        for (BDeviceJobStep step : steps) {
            if (this.isParallelSafeStep(service, op, step, allDevices)) {
                logger.info(() -> String.format("Step %s (%s) is parallel safe, adding to list of steps for parallel execution", step.getName(), ((Object)((Object)step)).getClass().getName()));
                parallelSafeSteps.add(step);
                continue;
            }
            logger.info(() -> String.format("Step  %s (%s) is not parallel safe, executing %d previous parallel safe steps", step.getName(), ((Object)((Object)step)).getClass().getName(), parallelSafeSteps.size()));
            BJobState newState = this.executeParallel(service, op, parallelSafeSteps.toArray(new BDeviceJobStep[0]), devices);
            jobState = newState.getOrdinal() > jobState.getOrdinal() ? newState : jobState;
            parallelSafeSteps.clear();
            logger.info(() -> String.format("Step  %s (%s) is not parallel safe, executing sequentially", step.getName(), ((Object)((Object)step)).getClass().getName()));
            newState = this.executeSequential(service, op, new BDeviceJobStep[]{step}, devices);
            jobState = newState.getOrdinal() > jobState.getOrdinal() ? newState : jobState;
        }
        logger.info(() -> String.format("All steps analyzed. Executing remaining %d parallel safe steps", parallelSafeSteps.size()));
        BJobState newState = this.executeParallel(service, op, parallelSafeSteps.toArray(new BDeviceJobStep[0]), devices);
        jobState = newState.getOrdinal() > jobState.getOrdinal() ? newState : jobState;
        return jobState;
    }

    private boolean isParallelSafeStep(BBatchJobService service, DeviceNetworkJobOp op, BDeviceJobStep step, Set<BDevice> allDevices) {
        for (BDevice device : allDevices) {
            Set<BDevice> conflicts = step.getParallelExecutionConflicts(service, device, allDevices, op);
            if (conflicts.size() <= 1 && (conflicts.size() != 1 || conflicts.contains(device))) continue;
            return false;
        }
        return true;
    }

    private BJobState executeParallel(BBatchJobService service, DeviceNetworkJobOp op, BDeviceJobStep[] steps, BDevice[] devices) {
        AtomicBoolean anyFailed = new AtomicBoolean(false);
        AtomicBoolean anyCanceled = new AtomicBoolean(false);
        CompletableFuture[] futures = new CompletableFuture[devices.length];
        Executor executor = service.getExecutor();
        for (int i = 0; i < devices.length; ++i) {
            BDevice device = devices[i];
            if (op.deviceFailed(device)) continue;
            BJobState deviceState = BJobState.running;
            this.setDeviceState(device, deviceState);
            this.getJob().log().message("batchJob", "ForEachDeviceStage.processingDevice", device.getDisplayName(null));
            BatchJobTask task = new BatchJobTask(this, service, device, op, steps, i);
            futures[i] = CompletableFuture.runAsync(task, executor).whenComplete((ok, ex) -> {
                if (ex != null) {
                    if (ex instanceof CancellationException) {
                        this.getJob().log().failed("batchJob", "ForEachDeviceStage.jobTaskCancelled", ex.getCause());
                        anyCanceled.set(true);
                    } else {
                        this.getJob().log().failed("batchJob", "ForEachDeviceStage.jobTaskFailed", ex.getCause());
                        anyFailed.set(true);
                    }
                }
            });
        }
        try {
            BJobState allTasksFutureResult = (BJobState)((CompletableFuture)CompletableFuture.allOf(futures).handle((ok, ex) -> {
                if (ex != null) {
                    this.getJob().log().failed("batchJob", "ForEachDeviceStage.deviceExecutionFailed", ex.getCause());
                }
                if (anyFailed.get()) {
                    return BJobState.failed;
                }
                if (anyCanceled.get()) {
                    return BJobState.canceled;
                }
                return BJobState.success;
            })).join();
            return allTasksFutureResult;
        }
        catch (Exception e) {
            this.getJob().log().failed("batchJob", "ForEachDeviceStage.deviceExecutionFailed", e.getCause());
            return BJobState.failed;
        }
    }

    private BJobState executeSequential(BBatchJobService service, DeviceNetworkJobOp op, BDeviceJobStep[] steps, BDevice[] devices) {
        boolean anyFailed = false;
        boolean anyCanceled = false;
        for (BDevice device : devices) {
            if (op.deviceFailed(device)) continue;
            BJobState deviceState = BJobState.running;
            this.setDeviceState(device, deviceState);
            this.getJob().log().message("batchJob", "ForEachDeviceStage.processingDevice", device.getDisplayName(null));
            for (BDeviceJobStep step : steps) {
                BDeviceStepDetails stepDetails;
                if (this.canPassDefaultCheck(device, step)) {
                    stepDetails = step.run(service, device, op);
                } else {
                    stepDetails = new BDeviceStepDetails(device, step);
                    step.add(SlotPath.escape((String)device.getName()), (BValue)stepDetails, 4);
                    JobLogItem[] logItems = this.getJob().log().getItems();
                    if (logItems != null) {
                        for (JobLogItem item : logItems) {
                            stepDetails.add(item);
                        }
                    }
                    stepDetails.failed("batchJob", "ForEachDeviceStage.fail.defaultCheck");
                    stepDetails.complete(BJobState.failed);
                }
                deviceState = stepDetails.getState();
                if (deviceState == BJobState.failed) {
                    this.stepComplete(service, stepDetails, op);
                    op.setDeviceFailed(device);
                    anyFailed = true;
                    break;
                }
                if (deviceState == BJobState.canceled || deviceState == BJobState.canceling) {
                    if (deviceState == BJobState.canceling) {
                        deviceState = BJobState.canceled;
                        stepDetails.setState(deviceState);
                    }
                    op.setDeviceFailed(device);
                    this.stepComplete(service, stepDetails, op);
                    anyCanceled = true;
                    break;
                }
                this.stepComplete(service, stepDetails, op);
            }
            this.setDeviceState(device, deviceState);
        }
        if (anyFailed) {
            return BJobState.failed;
        }
        if (anyCanceled) {
            return BJobState.canceled;
        }
        return BJobState.success;
    }

    @Override
    public void addStep(BJobStep step) {
        this.getSteps().add("step?", (BValue)step);
    }

    @Override
    public void removeAllSteps() {
        this.getSteps().removeAll();
    }

    @Override
    public BJobStep[] getAllSteps() {
        ArrayList<BJobStep> result = new ArrayList<BJobStep>();
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BDeviceJobStep.class)) {
            result.add((BJobStep)c.get());
        }
        return result.toArray(new BJobStep[result.size()]);
    }

    protected BDeviceJobStep[] getCombinedSteps(DeviceNetworkJobOp op) {
        ArrayList<BDeviceJobStep> result = new ArrayList<BDeviceJobStep>();
        BDeviceJobStep combineWith = null;
        ArrayList<String> excludedSteps = new ArrayList<String>();
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BDeviceJobStep.class)) {
            BDeviceJobStep step = (BDeviceJobStep)c.get();
            if (combineWith != null && combineWith.canCombine(step) && step.canCombine(step)) {
                combineWith.combine(step);
                if (step.get("ExcludeFromProgress") != null) continue;
                excludedSteps.add(step.getName());
                step.add("ExcludeFromProgress", (BValue)BBoolean.TRUE);
                continue;
            }
            result.add(step);
            combineWith = step;
        }
        if (!excludedSteps.isEmpty()) {
            logger.log(Level.INFO, String.format("Combined steps %s will be excluded from progress updates", ((Object)excludedSteps).toString()));
        }
        return result.toArray(new BDeviceJobStep[result.size()]);
    }

    @Override
    public void prepareStage(BObject target) throws Exception {
        SlotCursor c = this.getSteps().getProperties();
        while (c.next(BDeviceJobStep.class)) {
            ((BDeviceJobStep)c.get()).prepareStep(target);
        }
    }

    public void stepComplete(BBatchJobService batch, BDeviceStepDetails stepDetails, DeviceNetworkJobOp op) {
        ((BDeviceJobStep)stepDetails.getStep()).deviceJobStepComplete(stepDetails, op);
        try {
            BBatchJobStepLogFile logFile = BBatchJobStepLogFile.create(stepDetails, this.getJob().getStartTime());
            if ((stepDetails.getState() == BJobState.failed || stepDetails.getState() == BJobState.canceled) && this.getJob().getAlertOnStepFailure()) {
                batch.newAlert(stepDetails.getFailureAlarmMessage(null), logFile.getOrdInSession());
            }
            stepDetails.resetLog();
        }
        catch (Exception e) {
            Logger.getLogger("batchJob").log(Level.SEVERE, "error persisting job step", e);
        }
    }

    @Override
    public void jobComplete(BatchJobOp op) {
        for (BDeviceJobStep step : this.getCombinedSteps((DeviceNetworkJobOp)op)) {
            try {
                step.deviceNetworkJobComplete((DeviceNetworkJobOp)op);
            }
            catch (Exception e) {
                this.getJob().log().failed("batchJob", "ForEachDeviceStage.cleanupFailed", (Throwable)e);
            }
        }
    }

    protected final synchronized boolean isCanceled(BSimple deviceId) {
        if (this.getJob().isCanceled()) {
            return true;
        }
        BJobState deviceState = this.getDeviceState(deviceId);
        return deviceState == BJobState.canceling || deviceState == BJobState.canceled;
    }

    protected final synchronized void checkCanceled(BSimple deviceId) {
        this.getJob().checkCanceled();
        BJobState deviceState = this.getDeviceState(deviceId);
        if (deviceState == BJobState.canceling || deviceState == BJobState.canceled) {
            throw new JobCancelException();
        }
    }

    @Override
    public void doDispose(Context cx) {
        BJobStepDetails[] recs;
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        for (BJobStepDetails rec : recs = this.getJobStepDetails()) {
            try {
                rec.dispose();
            }
            catch (Exception e) {
                Logger.getLogger("batchJob").log(Level.SEVERE, "Error disposing step record", e);
            }
        }
    }

    public void doCancelDevice(BSimple deviceId, Context cx) {
        if (this.getJob().getJobState().isRunning()) {
            BJobState deviceState = this.getDeviceState(deviceId);
            if (deviceState.isRunning()) {
                this.setDeviceState(deviceId, BJobState.canceling);
            } else if (deviceState != BJobState.success && deviceState != BJobState.failed) {
                this.setDeviceState(deviceId, BJobState.canceled);
            }
        }
    }
}

