/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import java.util.ArrayList;
import java.util.Collections;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.job.BJobState;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BJobStage
extends BComponent {
    public static final Property stageName = BJobStage.newProperty((int)1, (String)"", null);
    public static final Property stageState = BJobStage.newProperty((int)1, (BValue)BJobState.unknown, null);
    public static final Type TYPE = Sys.loadType(BJobStage.class);
    protected final long JOB_RUN_DELAY = 3000L;

    public String getStageName() {
        return this.getString(stageName);
    }

    public void setStageName(String v) {
        this.setString(stageName, v, null);
    }

    public BJobState getStageState() {
        return (BJobState)this.get(stageState);
    }

    public void setStageState(BJobState v) {
        this.set(stageState, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJobStage() {
    }

    public BJobStage(String stageName) {
        this.setStageName(stageName);
    }

    public BBatchJob getJob() {
        BComplex p;
        for (p = this.getParent(); p != null && !(p instanceof BBatchJob); p = p.getParent()) {
        }
        return (BBatchJob)p;
    }

    public abstract BJobState doRun(BBatchJobService var1, BBatchJob var2, BatchJobOp var3);

    public BJobStepDetails[] getJobStepDetails() {
        ArrayList result = new ArrayList();
        for (BJobStep step : this.getAllSteps()) {
            Collections.addAll(result, step.getJobStepDetails());
        }
        return result.toArray(new BJobStepDetails[result.size()]);
    }

    public abstract void addStep(BJobStep var1);

    public abstract void removeAllSteps();

    public abstract BJobStep[] getAllSteps();

    public void prepareStage(BObject target) throws Exception {
    }

    public void jobComplete(BatchJobOp op) {
        for (BJobStep step : this.getAllSteps()) {
            step.jobComplete(op);
        }
    }

    public void doDispose(Context cx) {
    }
}

