/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BBatchJobHousekeepingJob;
import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.nre.util.NreForkJoinWorkerThreadFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BIJobSummaryManager;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BThreadPoolJobQueue;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraSlots(properties={@NiagaraProperty(name="jobQueue", type="baja:ThreadPoolJobQueue", defaultValue="new BThreadPoolJobQueue(1)"), @NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"alarm:AlarmClassEditor\")")}), @NiagaraProperty(name="summaryManagerType", type="baja:TypeSpec", defaultValue="BTypeSpec.make(\"batchJob\", \"HistoryJobSummaryManager\")", flags=1), @NiagaraProperty(name="initialSummaryManagerType", type="baja:TypeSpec", defaultValue="BTypeSpec.make(\"batchJob\", \"HistoryJobSummaryManager\")", flags=5), @NiagaraProperty(name="maxProvisioningThreads", type="int", defaultValue="2")}, actions={@NiagaraAction(name="submitJobAction", parameterType="batchJob:BatchJob", defaultValue="new BBatchJob()", returnType="baja:Ord", flags=4), @NiagaraAction(name="makeTempFilePath", parameterType="baja:String", defaultValue="BString.DEFAULT", returnType="baja:String", flags=4), @NiagaraAction(name="disposeJob", parameterType="baja:AbsTime", defaultValue="BAbsTime.NULL ", flags=4), @NiagaraAction(name="ackAlarm", parameterType="alarm:AlarmRecord", defaultValue="new BAlarmRecord()", flags=4, returnType="baja:Boolean"), @NiagaraAction(name="purgeDisposedHistory", flags=4), @NiagaraAction(name="performHousekeeping", flags=4)}, topics={@NiagaraTopic(name="jobDisposed", eventType="baja:AbsTime", flags=4)})
public class BBatchJobService
extends BAbstractService
implements BIAlarmSource,
BIRestrictedComponent {
    public static final Property jobQueue = BBatchJobService.newProperty((int)0, (BValue)new BThreadPoolJobQueue(1), null);
    public static final Property alarmClass = BBatchJobService.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor"))));
    public static final Property summaryManagerType = BBatchJobService.newProperty((int)1, (BValue)BTypeSpec.make((String)"batchJob", (String)"HistoryJobSummaryManager"), null);
    public static final Property initialSummaryManagerType = BBatchJobService.newProperty((int)5, (BValue)BTypeSpec.make((String)"batchJob", (String)"HistoryJobSummaryManager"), null);
    public static final Property maxProvisioningThreads = BBatchJobService.newProperty((int)0, (int)2, null);
    public static final Action submitJobAction = BBatchJobService.newAction((int)4, (BValue)new BBatchJob(), null);
    public static final Action makeTempFilePath = BBatchJobService.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action disposeJob = BBatchJobService.newAction((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action ackAlarm = BBatchJobService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action purgeDisposedHistory = BBatchJobService.newAction((int)4, null);
    public static final Action performHousekeeping = BBatchJobService.newAction((int)4, null);
    public static final Topic jobDisposed = BBatchJobService.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType(BBatchJobService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private static final FilePath BASE_DIR = new FilePath("^batchJob");
    public static final Logger logger = Logger.getLogger("batchJob");
    private AlarmSupport alarmSupport = null;
    private boolean serviceStarted = false;
    private Clock.Ticket purgeTicket;
    private ForkJoinPool executor;
    private BIJobSummaryManager summaryManager = null;
    private CompletableFuture<Void> whenServiceStarted = new CompletableFuture();

    public BThreadPoolJobQueue getJobQueue() {
        return (BThreadPoolJobQueue)this.get(jobQueue);
    }

    public void setJobQueue(BThreadPoolJobQueue v) {
        this.set(jobQueue, (BValue)v, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    public BTypeSpec getSummaryManagerType() {
        return (BTypeSpec)this.get(summaryManagerType);
    }

    public void setSummaryManagerType(BTypeSpec v) {
        this.set(summaryManagerType, (BValue)v, null);
    }

    public BTypeSpec getInitialSummaryManagerType() {
        return (BTypeSpec)this.get(initialSummaryManagerType);
    }

    public void setInitialSummaryManagerType(BTypeSpec v) {
        this.set(initialSummaryManagerType, (BValue)v, null);
    }

    public int getMaxProvisioningThreads() {
        return this.getInt(maxProvisioningThreads);
    }

    public void setMaxProvisioningThreads(int v) {
        this.setInt(maxProvisioningThreads, v, null);
    }

    public BOrd submitJobAction(BBatchJob parameter) {
        return (BOrd)this.invoke(submitJobAction, (BValue)parameter, null);
    }

    public BString makeTempFilePath(BString parameter) {
        return (BString)this.invoke(makeTempFilePath, (BValue)parameter, null);
    }

    public void disposeJob(BAbsTime parameter) {
        this.invoke(disposeJob, (BValue)parameter, null);
    }

    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    public void purgeDisposedHistory() {
        this.invoke(purgeDisposedHistory, null, null);
    }

    public void performHousekeeping() {
        this.invoke(performHousekeeping, null, null);
    }

    public void fireJobDisposed(BAbsTime event) {
        this.fire(jobDisposed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIFile makeTempFile(String extension) {
        BFileSpace fileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)this);
        return fileSpace.findFile(new FilePath(this.makeTempFilePath(BString.make((String)extension)).toString()));
    }

    public void started() throws Exception {
        this.purgeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)1), (Action)performHousekeeping, null);
    }

    public void stopped() {
        if (this.purgeTicket != null) {
            this.purgeTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == maxProvisioningThreads) {
            if (this.getMaxProvisioningThreads() > 10) {
                this.setMaxProvisioningThreads(10);
            } else if (this.getMaxProvisioningThreads() < 1) {
                this.setMaxProvisioningThreads(1);
            }
        }
        if (property == enabled) {
            this.updateStatus();
        } else if (property == alarmClass) {
            this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        BIJobSummaryManager manager = this.getJobSummaryManager();
        manager.startAsync();
        ((CompletableFuture)manager.whenManagerStarted().exceptionally(e -> {
            Logger.getLogger("batchJob").log(Level.SEVERE, "Job summary manager import failed", (Throwable)e);
            this.configFail(e.getLocalizedMessage());
            this.whenServiceStarted().completeExceptionally((Throwable)e);
            return null;
        })).thenApplyAsync(voidResult -> {
            if (!this.getInitialSummaryManagerType().equals((Object)this.getSummaryManagerType())) {
                try {
                    BIJobSummaryManager oldManager = (BIJobSummaryManager)this.getInitialSummaryManagerType().getInstance();
                    manager.importSummaries(oldManager);
                    oldManager.removeSummaryManager();
                    this.setInitialSummaryManagerType(this.getSummaryManagerType());
                }
                catch (Throwable e) {
                    this.configFail("Job summary import failed");
                    Logger.getLogger("batchJob").log(Level.SEVERE, "Job summary import failed", e);
                    this.whenServiceStarted().completeExceptionally(e);
                    return null;
                }
            }
            this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
            this.updateStatus();
            this.whenServiceStarted().complete(null);
            Logger.getLogger("batchJob").log(Level.INFO, "Batch Job Service Startup Complete");
            return null;
        });
        if (this.isOperational()) {
            int threadsPerCPU = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.batchJob.threadsPerCPU", String.valueOf(this.getMaxProvisioningThreads()))));
            int defaultThreads = Runtime.getRuntime().availableProcessors() * threadsPerCPU;
            int threads = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty("niagara.batchJob.threads", String.valueOf(defaultThreads))));
            this.executor = new ForkJoinPool(threads, NreForkJoinWorkerThreadFactory.DEFAULT_INSTANCE, new UncaughtSearchExceptionHandler(), true);
        }
    }

    public boolean completesStarted() {
        return true;
    }

    public CompletableFuture<Void> whenServiceStarted() {
        return this.whenServiceStarted;
    }

    public void serviceStopped() {
        this.serviceStarted = false;
        if (this.executor == null) {
            return;
        }
        this.executor.shutdownNow();
    }

    public void doPurgeDisposedHistory(Context cx) throws Exception {
        new BBatchJobHousekeepingJob().submit(cx);
    }

    public void doPerformHousekeeping(Context cx) throws Exception {
        new BBatchJobHousekeepingJob().submit(cx);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BBatchJob submitJob(BBatchJob localJobCopy, Context cx) throws Exception {
        localJobCopy.prepareJob((BObject)this);
        BOrd jobOrd = (BOrd)this.invoke(submitJobAction, (BValue)localJobCopy, cx);
        this.getComponentSpace().sync();
        return (BBatchJob)jobOrd.get((BObject)this);
    }

    public BOrd doSubmitJobAction(BBatchJob job, Context cx) throws Exception {
        job.clearHandles();
        job.submit(cx);
        return job.getHandleOrd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDisposeJob(BAbsTime jobStartTime) throws Exception {
        BJobService svc = (BJobService)Sys.getService((Type)BJobService.TYPE);
        for (BJob job : svc.getJobs()) {
            if (!(job instanceof BBatchJob) || !jobStartTime.equals((Object)job.getStartTime())) continue;
            job.dispose();
            return;
        }
        BBatchJobLogFile logFile = null;
        try {
            logFile = BBatchJobLogFile.findLocal(jobStartTime);
            BBatchJob job = logFile.getJob();
            job.dispose();
        }
        catch (Exception e) {
            Logger.getLogger("batchJob").log(Level.WARNING, "Can't find batch job log file", e);
            ArrayList stepSummaries = new ArrayList();
            for (TypeInfo stepTypeInfo : Sys.getRegistry().getConcreteTypes(BJobStep.TYPE.getTypeInfo())) {
                this.getJobSummaryManager().listStepSummaries(stepTypeInfo.getTypeSpec().getResolvedType(), "jobStartTime", (BSimple)jobStartTime, (BObject)this).forEach(stepSummaries::add);
            }
            for (BIJobStepSummary stepSummary : stepSummaries) {
                try {
                    BBatchJobStepLogFile stepLogFile = BBatchJobStepLogFile.find(stepSummary, (BObject)this);
                    try {
                        stepLogFile.getDetails().dispose();
                    }
                    catch (Exception detailsException) {
                        try {
                            this.getJobSummaryManager().disposeStepSummary(stepSummary.getStepType().getResolvedType(), stepSummary.getStartTime());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (stepLogFile == null) continue;
                        stepLogFile.delete();
                    }
                }
                catch (Exception stepLogFileException) {
                    try {
                        this.getJobSummaryManager().disposeStepSummary(stepSummary.getStepType().getResolvedType(), stepSummary.getStartTime());
                    }
                    catch (Exception detailsException) {}
                }
            }
            for (TypeInfo jobTypeInfo : Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo())) {
                try {
                    this.getJobSummaryManager().disposeJobSummary(jobTypeInfo.getTypeSpec().getResolvedType(), jobStartTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (logFile != null) {
                try {
                    logFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fireJobDisposed(jobStartTime);
        }
    }

    public void notifyDisposed(BBatchJob job) {
        this.fireJobDisposed(job.getStartTime());
    }

    public synchronized BString doMakeTempFilePath(BString extension) {
        int i = 0;
        while (true) {
            FilePath path;
            BIFile file;
            if ((file = BFileSystem.INSTANCE.findFile(path = BASE_DIR.merge("tmp" + i + "." + extension.toString()))) == null) {
                try {
                    BFileSystem.INSTANCE.makeFile(path);
                    return BString.make((String)path.getBody());
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    throw re;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            ++i;
        }
    }

    public static BIJobQueryManager getQueryManager(BIBatchJobSummary summary) throws Exception {
        AgentList agents = Sys.getRegistry().getAgents(summary.getType().getTypeInfo()).filter(AgentFilter.is((Type)BIJobQueryManager.TYPE));
        return agents.size() == 0 ? null : (BIJobQueryManager)agents.getDefault().getAgentType().getInstance();
    }

    public static BIJobQueryManager getQueryManager(BIJobStepSummary summary) throws Exception {
        AgentList agents = Sys.getRegistry().getAgents(summary.getType().getTypeInfo()).filter(AgentFilter.is((Type)BIJobQueryManager.TYPE));
        return agents.size() == 0 ? null : (BIJobQueryManager)agents.getDefault().getAgentType().getInstance();
    }

    public BIJobSummaryManager getJobSummaryManager() {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("getJobSummaryManager must be called from the supervisor VM");
        }
        return (BIJobSummaryManager)this.getJobQueryManager();
    }

    public BIJobQueryManager getJobQueryManager() {
        if (this.summaryManager == null) {
            this.summaryManager = (BIJobSummaryManager)this.getSummaryManagerType().getInstance();
        }
        return this.summaryManager;
    }

    public void newAlert(String messageText, BOrd hyperlinkOrd) {
        if (this.alarmSupport != null) {
            try {
                this.alarmSupport.newAlert(BFacets.make((String[])new String[]{"msgText", "hyperlinkOrd"}, (BIDataValue[])new BString[]{BString.make((String)messageText), BString.make((String)hyperlinkOrd.toString())}));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord ack) {
        try {
            if (this.alarmSupport != null) {
                this.alarmSupport.ackAlarm(ack);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BBoolean.TRUE;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public BIcon getIcon() {
        return icon;
    }

    static class UncaughtSearchExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        UncaughtSearchExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Uncaught exception from thread " + t + "\n" + e);
            }
        }
    }
}

