/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.collection.AbstractCursor;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.query.util.Predicates;
import javax.baja.retention.BIRetainable;
import javax.baja.retention.BIRetentionPolicyDomain;
import javax.baja.retention.BPermanentRetentionPolicy;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public abstract class BBatchJobPrototype
extends BComponent
implements BIRetentionPolicyDomain {
    public static final Property retentionPolicy = BBatchJobPrototype.newProperty((int)0, (BValue)new BPermanentRetentionPolicy(), (BFacets)BFacets.make((String[])new String[]{"fieldEditor", "retainableType", "domainType"}, (BIDataValue[])new BString[]{BString.make((String)"batchJob:RetentionPolicyFE"), BString.make((String)"batchJob:BatchJob"), BString.make((String)"batchJob:BatchJobPrototype")}));
    public static final Property retentionPolicyCheckFrequency = BBatchJobPrototype.newProperty((int)0, (BValue)BRelTime.HOUR, null);
    public static final Property jobPrototype = BBatchJobPrototype.newProperty((int)4, (BValue)new BBatchJob(), null);
    public static final Action submitJob = BBatchJobPrototype.newAction((int)8, null);
    public static final Action enforceRetentionPolicy = BBatchJobPrototype.newAction((int)0, null);
    public static final Topic jobComplete = BBatchJobPrototype.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BBatchJobPrototype.class);
    private static final BIcon icon = BIcon.std((String)"gears.png");
    private Clock.Ticket retentionCheckTicket = null;
    private boolean enforcing = false;

    public BRetentionPolicy getRetentionPolicy() {
        return (BRetentionPolicy)this.get(retentionPolicy);
    }

    public void setRetentionPolicy(BRetentionPolicy v) {
        this.set(retentionPolicy, (BValue)v, null);
    }

    public BRelTime getRetentionPolicyCheckFrequency() {
        return (BRelTime)this.get(retentionPolicyCheckFrequency);
    }

    public void setRetentionPolicyCheckFrequency(BRelTime v) {
        this.set(retentionPolicyCheckFrequency, (BValue)v, null);
    }

    public BBatchJob getJobPrototype() {
        return (BBatchJob)this.get(jobPrototype);
    }

    public void setJobPrototype(BBatchJob v) {
        this.set(jobPrototype, (BValue)v, null);
    }

    public BOrd submitJob() {
        return (BOrd)this.invoke(submitJob, null, null);
    }

    public void enforceRetentionPolicy() {
        this.invoke(enforceRetentionPolicy, null, null);
    }

    public void fireJobComplete(BOrd event) {
        this.fire(jobComplete, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJobPrototype() {
    }

    public BBatchJobPrototype(BBatchJob jobProto) {
        this.setJobPrototype(jobProto);
    }

    public BBatchJob submit() throws Exception {
        BOrd jobOrd = this.submitJob();
        this.getComponentSpace().sync();
        return (BBatchJob)jobOrd.get((BObject)this);
    }

    public void jobComplete(BBatchJob job, BIFile logFile) {
        this.enforceRetentionPolicy();
        this.fireJobComplete(job.getHandleOrd());
    }

    public IterableCursor<? extends BIBatchJobSummary> listBatchJobSummaries() {
        try {
            BBatchJobService svc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
            svc.lease(1);
            BIJobQueryManager mgr = svc.getJobQueryManager();
            return mgr.listJobSummaries(this.getJobPrototype().getType(), Predicates.eq((String)"prototypeOrd", (BSimple)this.getHandleOrd()), (BObject)this);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BOrd doSubmitJob(Context cx) throws Exception {
        BBatchJob job = this.createJobInstance(cx);
        job.submit(cx);
        return job.getHandleOrd();
    }

    protected BBatchJob createJobInstance(Context cx) throws Exception {
        BBatchJob result = (BBatchJob)this.getJobPrototype().newCopy();
        result.setPrototypeOrd(this.getHandleOrd());
        return result;
    }

    public void doEnforceRetentionPolicy() {
        new Thread(){

            @Override
            public void run() {
                if (BBatchJobPrototype.this.enforcing) {
                    return;
                }
                BBatchJobPrototype.this.enforcing = true;
                try {
                    BBatchJobPrototype.this.getRetentionPolicy().executePolicy(BBatchJobPrototype.this);
                    if (BBatchJobPrototype.this.retentionCheckTicket != null) {
                        BBatchJobPrototype.this.retentionCheckTicket.cancel();
                    }
                    BBatchJobPrototype.this.retentionCheckTicket = Clock.schedule((BComponent)BBatchJobPrototype.this, (BRelTime)BBatchJobPrototype.this.getRetentionPolicyCheckFrequency(), (Action)enforceRetentionPolicy, null);
                }
                finally {
                    BBatchJobPrototype.this.enforcing = false;
                }
            }
        }.start();
    }

    @Override
    public IterableCursor<? extends BIRetainable> getRetainables() {
        return new JobCursor((Cursor<? extends BIBatchJobSummary>)this.listBatchJobSummaries());
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == retentionPolicyCheckFrequency) {
            if (this.retentionCheckTicket != null) {
                this.retentionCheckTicket.cancel();
            }
            this.retentionCheckTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRetentionPolicyCheckFrequency(), (Action)enforceRetentionPolicy, null);
        }
        super.changed(property, context);
    }

    public void atSteadyState() throws Exception {
        this.enforceRetentionPolicy();
    }

    public BIcon getIcon() {
        return icon;
    }

    private class JobCursor
    extends AbstractCursor<BBatchJob> {
        private BBatchJob job;
        private final Cursor<? extends BIBatchJobSummary> historyCursor;

        public JobCursor(Cursor<? extends BIBatchJobSummary> historyCursor) {
            this.historyCursor = historyCursor;
        }

        protected boolean advanceCursor() {
            this.job = null;
            return this.historyCursor.next();
        }

        protected BBatchJob doGet() {
            if (this.job == null) {
                BIBatchJobSummary history = (BIBatchJobSummary)this.historyCursor.get();
                try {
                    this.job = history.getJob((BObject)BBatchJobPrototype.this);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            return this.job;
        }
    }
}

