/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.BatchJobOpImpl;
import javax.baja.batchJob.IJobDispatcher;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.retention.BILastModifiedRetainable;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BBatchJob
extends BJob
implements BILastModifiedRetainable {
    public static final Property submitUser = BBatchJob.newProperty((int)1, (String)"unknown", null);
    public static final Property alertOnStepFailure = BBatchJob.newProperty((int)1, (boolean)true, null);
    public static final Property alertOnJobSuccess = BBatchJob.newProperty((int)1, (boolean)false, null);
    public static final Property stages = BBatchJob.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property prototypeOrd = BBatchJob.newProperty((int)65, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BBatchJob.class);
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private BBatchJobLogFile jobFile = null;
    private BTimeZone startTimeLocalTz = BTimeZone.NULL;

    public String getSubmitUser() {
        return this.getString(submitUser);
    }

    public void setSubmitUser(String v) {
        this.setString(submitUser, v, null);
    }

    public boolean getAlertOnStepFailure() {
        return this.getBoolean(alertOnStepFailure);
    }

    public void setAlertOnStepFailure(boolean v) {
        this.setBoolean(alertOnStepFailure, v, null);
    }

    public boolean getAlertOnJobSuccess() {
        return this.getBoolean(alertOnJobSuccess);
    }

    public void setAlertOnJobSuccess(boolean v) {
        this.setBoolean(alertOnJobSuccess, v, null);
    }

    public BFolder getStages() {
        return (BFolder)this.get(stages);
    }

    public void setStages(BFolder v) {
        this.set(stages, (BValue)v, null);
    }

    public BOrd getPrototypeOrd() {
        return (BOrd)this.get(prototypeOrd);
    }

    public void setPrototypeOrd(BOrd v) {
        this.set(prototypeOrd, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJob() {
    }

    public BBatchJob(BJobStage[] stages) {
        for (BJobStage stage : stages) {
            this.addStage(stage);
        }
    }

    public BBatchJob(BJobStage stage) {
        this.addStage(stage);
    }

    public static BBatchJob findMounted(BAbsTime startTime, BObject base) {
        BJob[] jobs;
        BJobService svc = (BJobService)BOrd.make((String)"service:baja:JobService").get(base);
        svc.lease(2);
        for (BJob job : jobs = svc.getJobs()) {
            if (!(job instanceof BBatchJob) || !startTime.equals((Object)job.getStartTime())) continue;
            return (BBatchJob)job;
        }
        return null;
    }

    public static BBatchJob find(BAbsTime startTime, BObject base) {
        return BBatchJob.find(null, startTime, base);
    }

    public static BBatchJob find(Type jobType, BAbsTime startTime, BObject base) {
        BBatchJob mounted = BBatchJob.findMounted(startTime, base);
        if (mounted != null) {
            return mounted;
        }
        try {
            BBatchJobLogFile file = BBatchJobLogFile.find(jobType, startTime, base);
            return file.getJob();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BObject getOrdBase() {
        if (this.jobFile == null) {
            return this;
        }
        return this.jobFile;
    }

    @Override
    public BAbsTime getLastModified() {
        return this.getEndTime().isNull() ? this.getStartTime() : this.getEndTime();
    }

    public void addStage(BJobStage stage) {
        this.getStages().add(SlotPath.escape((String)stage.getStageName()), (BValue)stage);
    }

    public BJobStage getStage(String stageName) {
        Property prop = this.getStages().getProperty(SlotPath.escape((String)stageName));
        return prop == null ? null : (BJobStage)this.getStages().get(prop);
    }

    public BJobStage[] getAllStages() {
        return (BJobStage[])this.getStages().getProperties().stream().map(p -> this.getStages().get(p)).filter(v -> v instanceof BJobStage).toArray(BJobStage[]::new);
    }

    public BJobStepDetails[] getJobStepDetails() {
        ArrayList result = new ArrayList();
        for (BJobStage stage : this.getAllStages()) {
            Collections.addAll(result, stage.getJobStepDetails());
        }
        return result.toArray(new BJobStepDetails[result.size()]);
    }

    public BatchJobOp makeOp(Context cx) {
        return new BatchJobOpImpl(cx);
    }

    public IJobDispatcher getDispatcher() {
        BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        return svc.getJobQueue();
    }

    public void prepareJob(BObject target) throws Exception {
        SlotCursor c = this.getStages().getProperties();
        while (c.next(BJobStage.class)) {
            ((BJobStage)c.get()).prepareStage(target);
        }
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    public void doSubmit(Context cx) {
        if (cx != null) {
            this.setSubmitUser(String.valueOf(cx.getUser()));
        }
        this.setJobState(BJobState.unknown);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
        this.getDispatcher().dispatch(this, cx);
    }

    public final void doCancel(Context cx) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        } else if (this.getJobState() != BJobState.success && this.getJobState() != BJobState.failed) {
            this.complete(BJobState.canceled);
        }
        this.getDispatcher().cancel(this, cx);
    }

    public void doRun(Context cx) {
        BatchJobOp op = this.makeOp(cx);
        BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        boolean anyFailed = false;
        boolean anyCanceled = false;
        for (BJobStage stage : this.getAllStages()) {
            BJobState stageState = stage.doRun(svc, this, op);
            if (stageState == BJobState.failed) {
                anyFailed = true;
                continue;
            }
            if (stageState != BJobState.canceled && stageState != BJobState.canceling) continue;
            anyCanceled = true;
        }
        for (BJobStage stage : this.getAllStages()) {
            try {
                stage.jobComplete(op);
            }
            catch (Exception e) {
                this.log().failed("batchJob", "BatchJob.jobCompleteFailed", (Throwable)e);
            }
        }
        if (anyFailed) {
            this.log().failed("batchJob", "BatchJob.someStepsFailed");
            this.complete(BJobState.failed);
        } else if (anyCanceled) {
            this.log().failed("batchJob", "BatchJob.jobCanceled");
            this.complete(BJobState.canceled);
        } else {
            this.success();
        }
    }

    public void doDispose(Context cx) {
        if (this.getJobState().isRunning()) {
            throw new IllegalStateException("Cannot dispose while running");
        }
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        this.setJobState(BJobState.unknown);
        for (BJobStage stage : this.getAllStages()) {
            try {
                stage.doDispose(cx);
            }
            catch (Exception e) {
                Logger.getLogger("batchJob").log(Level.SEVERE, "Error disposing stage", e);
            }
        }
        try {
            BBatchJobLogFile logFile = BBatchJobLogFile.find(this, null);
            try {
                Logger.getLogger("batchJob").fine("Deleting log file " + logFile.getFilePath().getBody());
                AccessController.doPrivileged(() -> {
                    logFile.delete();
                    return null;
                });
            }
            catch (Exception e) {
                Logger.getLogger("batchJob").log(Level.SEVERE, "Error deleting log file " + logFile.getFilePath(), e);
            }
        }
        catch (UnresolvedException ue) {
            Logger.getLogger("batchJob").log(Level.FINE, "Log file not found", ue);
        }
        if (this.getParent() != null && this.getParent() instanceof BJobService) {
            try {
                ((BComponent)this.getParent()).remove((BComplex)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            svc.getJobSummaryManager().disposeJobSummary(this.getType(), this.getStartTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        svc.notifyDisposed(this);
    }

    public void complete(BJobState state) {
        super.complete(state);
        try {
            this.jobFile = BBatchJobLogFile.create(this);
            if (!this.getPrototypeOrd().isNull()) {
                BBatchJobPrototype proto = (BBatchJobPrototype)this.getPrototypeOrd().get((BObject)this);
                proto.jobComplete(this, (BIFile)this.jobFile);
            }
            this.resetLog();
        }
        catch (Exception e) {
            Logger.getLogger("batchJob").log(Level.SEVERE, "error persisting job", e);
        }
        BBatchJobService svc = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        if (this.getJobState() == BJobState.success && this.getAlertOnJobSuccess()) {
            svc.newAlert(Lexicon.make((String)"batchJob").getText("BatchJob.successAlarmMessage"), this.jobFile.getOrdInSession());
        }
        try {
            svc.getJobSummaryManager().write(svc.getJobSummaryManager().makeJobSummary(this));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public BString doReadLog() {
        if (this.getJobState().isComplete()) {
            BBatchJobLogFile logFile = (BBatchJobLogFile)this.getLogFile();
            if (logFile == null) {
                return BString.DEFAULT;
            }
            try {
                return logFile.getLogContents();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return super.doReadLog();
    }

    public void setLogFile(BIFile value) {
        this.jobFile = (BBatchJobLogFile)value;
    }

    public BIFile getLogFile() {
        if (this.jobFile == null) {
            this.jobFile = BBatchJobLogFile.find(this, null);
        }
        return this.jobFile;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void checkCanceled() {
        if (this.isCanceled()) {
            throw new JobCancelException();
        }
    }

    public void setDisplayTimeZone(BTimeZone displayTz) {
        if (this.isMounted()) {
            throw new IllegalStateException("cannot call setDisplayTimeZone on mounted job");
        }
        if (displayTz == null || displayTz.isNull()) {
            throw new IllegalArgumentException("displayTz cannot be null");
        }
        if (this.startTimeLocalTz.isNull()) {
            this.startTimeLocalTz = this.getStartTime().getTimeZone();
        }
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, startTime, displayTz);
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, endTime, displayTz);
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, heartbeatTime, displayTz);
        for (BJobStepDetails detail : this.getJobStepDetails()) {
            detail.setDisplayTimeZone(displayTz);
        }
    }

    public void setStartTimeLocalZone(BTimeZone localTz) {
        this.startTimeLocalTz = localTz;
    }

    public BAbsTime getLocalStartTime() {
        if (this.startTimeLocalTz.isNull() && this.getSession() != null) {
            try {
                BComponent systemPlatformService = (BComponent)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)this);
                systemPlatformService.lease();
                this.setStartTimeLocalZone((BTimeZone)systemPlatformService.get("timeZone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startTimeLocalTz.isNull()) {
            return this.getStartTime();
        }
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.startTimeLocalTz);
    }
}

