/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Supplier;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public final class SupplierInputStream
extends InputStream {
    private static final InputStream emptyInputStream = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private InputStream in;
    private int separator;
    private Deque<Supplier<InputStream>> stack;

    public SupplierInputStream(Collection<Supplier<InputStream>> suppliers, int separator) {
        this.stack = new ArrayDeque<Supplier<InputStream>>(suppliers);
        this.separator = separator;
    }

    public SupplierInputStream(Collection<Supplier<InputStream>> suppliers) {
        this(suppliers, 10);
    }

    @Override
    public int read() throws IOException {
        if (this.in == null && !this.stack.isEmpty()) {
            this.in = this.stack.pop().get();
        }
        if (this.in == null) {
            return -1;
        }
        int read = this.in.read();
        if (read <= 0) {
            this.in.close();
            this.in = null;
            return this.stack.isEmpty() ? read : this.separator;
        }
        return read;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if (this.in == null && !this.stack.isEmpty()) {
            this.in = this.stack.pop().get();
        }
        if (this.in == null) {
            return -1;
        }
        int r0 = this.in.read(bytes, offset, length);
        if (r0 == length) {
            return r0;
        }
        if (r0 > length) {
            throw new IndexOutOfBoundsException();
        }
        if (r0 <= 0) {
            int r1;
            this.in.close();
            this.in = null;
            if (this.stack.isEmpty()) {
                return r0;
            }
            bytes[offset] = (byte)this.separator;
            return (r1 = this.read(bytes, ++offset, --length)) == -1 ? -1 : r1 + 1;
        }
        int r1 = this.read(bytes, offset + r0, length - r0);
        return r1 == -1 ? r0 : r0 + r1;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public static InputStream toInputStream(String str) {
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return emptyInputStream;
        }
    }

    public static InputStream toInputStream(BOrd ord) {
        if (ord.isNull()) {
            return emptyInputStream;
        }
        try {
            BIFile file = (BIFile)ord.get();
            return file.getInputStream();
        }
        catch (Exception e) {
            return emptyInputStream;
        }
    }

    public static InputStream toEmptyStream() {
        return emptyInputStream;
    }
}

