/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BCommControlConfig;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.security.BPassword;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BDeviceCommControlJob
extends BDeviceManagerJob {
    public static final Type TYPE = Sys.loadType(BDeviceCommControlJob.class);
    private BCommControlConfig params;
    static Lexicon lex = Lexicon.make((String)"bacnetAws");

    public Type getType() {
        return TYPE;
    }

    public BDeviceCommControlJob() {
    }

    public BDeviceCommControlJob(BBacnetAwsNetwork bacnet, BCommControlConfig params) {
        super((BBacnetNetwork)bacnet);
        this.params = params;
    }

    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Executing Communication Control to device at " + this.params.getDeviceAddress() + ": " + this.params.getEnableDisable() + " for " + this.params.getDuration());
        }
        try {
            String password = null;
            String pw = AccessController.doPrivileged(() -> ((BPassword)this.params.getPassword()).getValue());
            if (pw.length() > 0) {
                password = pw;
            }
            this.client().deviceCommunicationControl(this.params.getDeviceAddress(), this.params.getEnableDisable(), this.params.getDuration(), password, this.params.getCharacterSet());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception sending DeviceCommunicationControl: " + e, e);
            String msg = MessageFormat.format(lex.getText("devCommCtrl.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            throw e;
        }
    }
}

