/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.history;

import com.tridium.bacnet.history.BAbstractBacnetHistory;
import com.tridium.bacnet.history.BacnetTrendLogUtil;
import com.tridium.bacnet.services.confirmed.ReadRangeAck;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnetAws.datatypes.BBacnetEventLogRecord;
import javax.baja.driver.history.ArchiveException;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class BBacnetEventLogImport
extends BAbstractBacnetHistory
implements BacnetConst {
    public static final Property localHistoryNames = BBacnetEventLogImport.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BBacnetEventLogImport.class);
    public static final Logger logger = Logger.getLogger("bacnet.history");
    public static final Lexicon lex = Lexicon.make((String)"bacnet");
    byte[] prev = null;
    String[] prevNams = null;
    boolean oprChange = true;

    public String getLocalHistoryNames() {
        return this.getString(localHistoryNames);
    }

    public void setLocalHistoryNames(String v) {
        this.setString(localHistoryNames, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doExecute() throws ArchiveException {
        if (!this.isRunning()) {
            return;
        }
        BBacnetDevice device = this.device();
        if (!device.isServiceSupported("readRange")) {
            this.executeFail(lex.getText("serviceNotSupported.readRange"));
            return;
        }
        BHistoryDatabase db = this.getHistoryDb();
        this.verifyLocalNameFormat();
        try (HistorySpaceConnection conn = db.getConnection(null);){
            BIHistory history = this.getOrCreateHistory(conn);
            if (history == null) {
                return;
            }
            long referenceIndex = -1L;
            int rangeType = 6;
            BBacnetDateTime referenceTime = this.getReferenceTime();
            int count = this.getMaxRecordsPerRequest();
            if (count == 0) {
                count = 10;
            }
            try {
                referenceIndex = this.determineNextIndex();
                if (referenceIndex < 0L) {
                    return;
                }
                ReadRangeAck prevResponse = null;
                boolean moreItems = true;
                while (moreItems) {
                    ReadRangeAck response = this.client().readRange(device.getAddress(), this.getObjectId(), 131, -1, rangeType, referenceIndex, referenceTime, count);
                    if (response == null) {
                        if (!logger.isLoggable(Level.INFO)) break;
                        logger.info("Error importing history data for " + (Object)((Object)this) + ": null response from device!");
                        break;
                    }
                    if (response.equals(prevResponse)) {
                        if (!logger.isLoggable(Level.INFO)) break;
                        logger.info("Error importing history data for " + (Object)((Object)this) + ": duplicate response (loop?):\nResponse:" + response);
                        break;
                    }
                    prevResponse = response;
                    byte[] encodedValue = response.getItemData();
                    if (encodedValue == null || encodedValue.length == 0) break;
                    moreItems = response.isMoreItems() || !response.includesLastItem();
                    this.asnIn.setBuffer(encodedValue);
                    long currentSeqNum = response.getFirstSequenceNumber();
                    if (currentSeqNum == -1L) {
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber((long)this.getLastSequenceNumberProcessed());
                    }
                    Array a = new Array(BBacnetEventLogRecord.class);
                    while (this.asnIn.peekTag() != -1) {
                        BBacnetEventLogRecord entry = new BBacnetEventLogRecord();
                        entry.readAsn((AsnInput)this.asnIn);
                        a.add((Object)entry);
                    }
                    BBacnetEventLogRecord[] recs = (BBacnetEventLogRecord[])a.trim();
                    BBacnetEventLogRecord lstRec = recs[recs.length - 1];
                    this.getReferenceTime().copyFrom((BComplex)lstRec.getTimestamp());
                    this.setLastSequenceNumberProcessed(response.getFirstSequenceNumber() + (long)recs.length - 1L);
                    for (int i = 0; i < recs.length; ++i) {
                        BBacnetEventLogRecord entry = recs[i];
                        try {
                            BHistoryRecord rec = entry.initializeNiagaraRecord(history.getConfig().makeRecord(), currentSeqNum);
                            conn.append(history, (BIHistoryRecordSet)this.correctTimestamp(rec));
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.INFO)) break;
                            logger.info("Ignore trend record " + currentSeqNum + ":" + e.toString());
                            break;
                        }
                        currentSeqNum = BacnetTrendLogUtil.incrementSequenceNumber((long)currentSeqNum);
                    }
                    if (!moreItems) continue;
                    referenceIndex = BacnetTrendLogUtil.incrementSequenceNumber((long)this.getLastSequenceNumberProcessed());
                    referenceTime = this.getReferenceTime();
                }
                this.executeOk();
            }
            catch (Exception e) {
                this.executeFail(e);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Asn Exception reading range (device " + device.getAddress() + ", id " + this.getObjectId() + ", rangeType " + rangeType + ", referenceIndex " + referenceIndex + ", referenceTime " + referenceTime + ", count " + count + ")", e);
                }
                throw new ArchiveException((Throwable)e);
            }
            finally {
                this.setState(BDescriptorState.idle);
            }
        }
    }

    protected BTypeSpec getTypeSpec() {
        return BTypeSpec.make((String)"bacnetAws", (String)"BacnetEventRecord");
    }
}

