/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.commands;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.commands.WsCommand;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BWsAnnotation;

public class ResizeCommand
extends WsCommand {
    ComponentGlyph[] glyphs;
    BWsAnnotation[] oldAnnos;
    BWsAnnotation[] newAnnos;
    Artifact artifact;

    public ResizeCommand(BWireSheetPane ws, ComponentGlyph[] glyphs, BWsAnnotation[] newAnnos) {
        super(ws, "ws.move");
        this.glyphs = glyphs;
        this.newAnnos = newAnnos;
        this.oldAnnos = new BWsAnnotation[glyphs.length];
        for (int i = 0; i < glyphs.length; ++i) {
            this.oldAnnos[i] = glyphs[i].toAnnotation();
        }
        this.artifact = new Artifact();
    }

    public CommandArtifact doInvoke() throws Exception {
        this.artifact.redo();
        return this.artifact;
    }

    void swap() {
        BWsAnnotation[] temp = this.oldAnnos;
        this.oldAnnos = this.newAnnos;
        this.newAnnos = temp;
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void redo() throws Exception {
            for (int i = 0; i < ResizeCommand.this.glyphs.length; ++i) {
                BWsAnnotation a = ResizeCommand.this.newAnnos[i];
                ResizeCommand.this.ws.grid.set(ResizeCommand.this.glyphs[i].p, ResizeCommand.this.glyphs[i].q, ResizeCommand.this.glyphs[i].ww, ResizeCommand.this.glyphs[i].wh, 0);
                ResizeCommand.this.glyphs[i].setWixelBounds(a.p, a.q, a.wixelWidth, a.wixelHeight);
            }
            ResizeCommand.this.ws.grid.clearLinks();
            ResizeCommand.this.ws.controller.saveAnnotations(ResizeCommand.this.glyphs);
            ResizeCommand.this.ws.controller.reload();
        }

        public void undo() throws Exception {
            ResizeCommand.this.swap();
            this.redo();
            ResizeCommand.this.swap();
        }
    }
}

