/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.RelationKnobGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsSelectedState;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.ui.Subject;

public class WsSelection
implements WsConst {
    public final BWireSheetPane ws;
    private ArrayList<Glyph> selection = new ArrayList();
    private HashMap<WsSelectedState, Glyph> byKey = new HashMap();
    private Array<Integer> selectionIndexArray = new Array(Integer.class);

    public WsSelection(BWireSheetPane ws) {
        this.ws = ws;
    }

    public synchronized Glyph[] get() {
        return this.selection.toArray(new Glyph[this.selection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Glyph glyph) {
        if (!glyph.isSelectable()) {
            throw new IllegalStateException();
        }
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            if (glyph.isSelected()) {
                return;
            }
            this.selection.add(glyph);
            glyph.setSelected(true);
            glyph.getParent().toTop(glyph);
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselect(Glyph glyph) {
        if (!glyph.isSelectable()) {
            throw new IllegalStateException();
        }
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            if (!glyph.isSelected()) {
                return;
            }
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) != glyph) continue;
                this.selection.remove(i);
                break;
            }
            glyph.setSelected(false);
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            ComponentGlyph[] glyphs = this.ws.controller.getAllComponentGlyphs();
            for (int i = 0; i < glyphs.length; ++i) {
                ComponentGlyph glyph = glyphs[i];
                if (!glyph.isSelectable()) continue;
                this.select(glyph);
            }
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectAll() {
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            for (int i = 0; i < this.selection.size(); ++i) {
                this.selection.get(i).setSelected(false);
            }
            this.selection.clear();
        }
        this.selectionChanged();
    }

    private void selectionChanged() {
        this.ws.controller.updateTransferStates();
        this.ws.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentGlyph[] getComponentGlyphs() {
        ArrayList<Glyph> arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList<Glyph> a = new ArrayList<Glyph>();
            for (int i = 0; i < this.selection.size(); ++i) {
                if (!(this.selection.get(i) instanceof ComponentGlyph)) continue;
                a.add(this.selection.get(i));
            }
            return a.toArray(new ComponentGlyph[a.size()]);
        }
    }

    public BComponent[] getComponents() {
        ComponentGlyph[] glyphs = this.getComponentGlyphs();
        BComponent[] components = new BComponent[glyphs.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = glyphs[i].component;
        }
        return components;
    }

    public void setComponents(BComponent[] components) {
        this.unselectAll();
        for (int i = 0; i < components.length; ++i) {
            BOrd ord = components[i].getHandleOrd();
            ComponentGlyph glyph = this.ws.controller.toComponentGlyph(ord);
            if (glyph == null) continue;
            this.select(glyph);
        }
    }

    public Subject getSubject() {
        return new Subject((Object[])this.getComponents());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkGlyph[] getLinkGlyphs() {
        ArrayList<Glyph> arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList<Glyph> a = new ArrayList<Glyph>();
            for (int i = 0; i < this.selection.size(); ++i) {
                if (!(this.selection.get(i) instanceof LinkGlyph)) continue;
                a.add(this.selection.get(i));
            }
            return a.toArray(new LinkGlyph[a.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLink[] getLinks() {
        ArrayList<Glyph> arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList<BLink> a = new ArrayList<BLink>();
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof LinkLinkGlyph) {
                    a.add(((LinkLinkGlyph)this.selection.get((int)i)).link);
                    continue;
                }
                if (!(this.selection.get(i) instanceof LinkKnobGlyph)) continue;
                a.add(((LinkKnobGlyph)this.selection.get(i)).getLink());
            }
            return a.toArray(new BLink[a.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BRelation[] getRelations() {
        ArrayList<Glyph> arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList<BRelation> a = new ArrayList<BRelation>();
            for (int i = 0; i < this.selection.size(); ++i) {
                if (this.selection.get(i) instanceof LinkLinkGlyph) {
                    a.add(((LinkLinkGlyph)this.selection.get((int)i)).relation);
                    continue;
                }
                if (!(this.selection.get(i) instanceof RelationKnobGlyph)) continue;
                a.add(((RelationKnobGlyph)this.selection.get(i)).getRelation());
            }
            return a.toArray(new BRelation[a.size()]);
        }
    }

    public WsSelectedState[] saveSelectedStates() {
        Glyph[] glyphs = this.get();
        WsSelectedState[] keys = new WsSelectedState[glyphs.length];
        for (int i = 0; i < glyphs.length; ++i) {
            keys[i] = glyphs[i].saveSelectedState();
        }
        return keys;
    }

    public void restoreSelectedStates(WsSelectedState[] states) {
        this.unselectAll();
        for (int i = 0; i < states.length; ++i) {
            Glyph glyph = this.byKey.get(states[i]);
            if (glyph != null) {
                this.select(glyph);
                glyph.restoreSelectedState(states[i]);
                continue;
            }
            states[i].cancelRestore();
        }
    }

    public Glyph getSelectableGlyphAt(int p, int q) {
        return this.ws.getCanvas().getRootGlyph().getSelectableGlyphAt(p, q);
    }

    public ResizeZone getResizeAt(double x, double y) {
        for (int i = 0; i < this.selection.size(); ++i) {
            Glyph g = this.selection.get(i);
            ResizeZone zone = g.getResizeAt(x, y);
            if (zone == null) continue;
            return zone;
        }
        return null;
    }

    public RectGeom getSelectionPixelBounds() {
        RectGeom bounds = null;
        Glyph[] selection = this.get();
        for (int i = 0; i < selection.length; ++i) {
            Glyph g = selection[i];
            if (!(g instanceof ComponentGlyph)) continue;
            RectGeom rect = new RectGeom((double)g.x, (double)g.y, (double)g.pw, (double)g.ph);
            if (bounds == null) {
                bounds = rect;
                continue;
            }
            RectGeom.bounds((IRectGeom)rect, (IRectGeom)bounds, (RectGeom)bounds);
        }
        return bounds;
    }

    WsSelectedState[] preLoad() {
        WsSelectedState[] states = this.saveSelectedStates();
        this.selection.clear();
        this.byKey.clear();
        return states;
    }

    void postLoad(WsSelectedState[] states) {
        this.addToKeyMap(this.ws.getCanvas().rootGlyph);
        this.restoreSelectedStates(states);
    }

    private void addToKeyMap(Glyph g) {
        if (g.isSelectable()) {
            WsSelectedState state = g.saveSelectedState();
            if (this.byKey.get(state) != null) {
                throw new IllegalStateException("Duplicate selection keys: " + state);
            }
            this.byKey.put(state, g);
        }
        Glyph[] kids = g.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            this.addToKeyMap(kids[i]);
        }
    }

    int registerNewStdSelectionIndex() {
        Array<Integer> array = this.selectionIndexArray;
        synchronized (array) {
            int i = 0;
            while (true) {
                Integer index;
                if (!this.selectionIndexArray.contains((Object)(index = new Integer(i)))) {
                    this.selectionIndexArray.add((Object)index);
                    return index;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStdSelectionIndex(int selectionIndex) {
        Array<Integer> array = this.selectionIndexArray;
        synchronized (array) {
            Integer index = new Integer(selectionIndex);
            if (!this.selectionIndexArray.contains((Object)index)) {
                this.selectionIndexArray.add((Object)index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStdSelectionIndex(int selectionIndex) {
        Array<Integer> array = this.selectionIndexArray;
        synchronized (array) {
            this.selectionIndexArray.remove((Object)new Integer(selectionIndex));
        }
    }
}

