/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.style.IStylable;

public class TitleBarGlyph
extends Glyph {
    BComponent component;
    BImage icon;
    String name;
    String type;
    String statusMessage;

    public TitleBarGlyph(BWireSheetPane ws, BComponent component) {
        super(ws);
        this.component = component;
        this.icon = BImage.make((BIcon)component.getIcon());
        if (this.icon == null) {
            this.icon = objectIcon;
        }
        this.type = component.getTypeDisplayName(null);
        this.renamed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        boolean cut = this.component.isPendingMove();
        WiresheetTheme theme = Theme.wiresheet();
        BImage img = cut ? this.icon.getDisabledImage() : this.icon;
        img = img.transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0)));
        BFont titleFont = theme.glyph().getTitleFont((IStylable)this);
        BFont subtitleFont = theme.glyph().getSubtitleFont((IStylable)this);
        g.push();
        try {
            g.setBrush(theme.glyph().getBackground((IStylable)this));
            g.fillRect(1.0, 1.0, (double)(this.pw - 2), (double)(this.ws.grid.wixel * 2));
            g.clip(0.0, 0.0, (double)(this.pw - this.ws.grid.wixel) - img.getWidth(), (double)this.ph);
            g.setBrush(theme.glyph().getFontColor((IStylable)this));
            g.setFont(WsController.getFont(titleFont, this.ws.grid.wixel - 2));
            g.drawString(this.name, 4.0, (double)this.ws.grid.wixel);
            g.setFont(WsController.getFont(subtitleFont, this.ws.grid.wixel - 2));
            g.drawString(this.type, 4.0, (double)(this.ws.grid.wixel + this.ws.grid.wixel - 2));
        }
        finally {
            g.pop();
        }
        g.drawImage(img, (double)(this.pw - this.ws.grid.wixel / 2) - img.getWidth(), ((double)(this.ws.grid.wixel * 2) - img.getHeight()) / 2.0);
    }

    @Override
    public String getStyleSelector() {
        return "wire-sheet glyph title";
    }

    @Override
    public String getStyleClasses() {
        String styleClasses = super.getStyleClasses();
        styleClasses = this.component.isPendingMove() ? StyleUtils.addStyleClass((String)styleClasses, (String)"cut") : StyleUtils.removeStyleClass((String)styleClasses, (String)"cut");
        return styleClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(WsPrinting p) {
        Graphics g = p.graphics;
        g.push();
        try {
            double w = (double)this.ww * p.wixel;
            double h = (double)this.wh * p.wixel;
            g.clip(0.0, 0.0, w, h);
            g.setBrush(BColor.black.toBrush());
            g.setFont(p.bold);
            g.drawString(this.name, 1.0, p.bold.getAscent());
            g.setBrush(BColor.make((int)0x666666));
            g.setFont(p.small);
            g.drawString(this.type, 1.0, p.wixel + p.small.getAscent());
            g.setBrush(BColor.black.toBrush());
            g.strokeLine(0.0, h, w, h);
        }
        finally {
            g.pop();
        }
    }

    public void renamed() {
        this.name = this.component.getDisplayName(null);
        this.statusMessage = this.component.toPathString() + " h:" + this.component.getHandle() + " [" + this.type + "]";
    }

    @Override
    public void mouseEntered() {
        this.showStatus(this.statusMessage);
    }

    double calcWidth() {
        WiresheetTheme.Glyph glyph = Theme.wiresheet().glyph();
        BFont titleFont = glyph.getTitleFont((IStylable)this);
        BFont subtitleFont = glyph.getSubtitleFont((IStylable)this);
        double tw = Math.floor(Math.max(WsController.getFont(titleFont, this.ws.grid.wixel - 2).width(this.name), WsController.getFont(subtitleFont, this.ws.grid.wixel - 2).width(this.type)));
        BImage img = this.icon;
        img = img.transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0)));
        return tw + img.getWidth() + (double)this.ws.grid.wixel + 8.0;
    }
}

