/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.WsConst;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;

public class TileImages
implements WsConst {
    private static final String[] h = new String[]{"            ", "            ", "jjjjjjjjjjjj", "            ", "xxxxxxxxxxxx", "............", "xxxxxxxxxxxx", "            ", "jjjjjjjjjjjj", "            ", "            ", "            "};
    private static final String[] v = new String[]{"  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] hCross = new String[]{"            ", "            ", "jjjjjj   jjj", "            ", "xxxxxx   xxx", "......   ...", "xxxxxx   xxx", "            ", "jjjjjj   jjj", "            ", "            ", "            "};
    private static final String[] vCross = new String[]{"  j x.x j   ", "  j x.x j   ", "   j x.x j  ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "    j x.x j ", "   j x.x j  ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] right2down = new String[]{"            ", "            ", "        jjjj", "       j    ", "      j  xxx", "     j xx...", "    j x..xxx", "   j x..x   ", "   j x.x jjj", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] right2up = new String[]{"  j x.x j   ", "  j x.x j   ", "   j x.x jjj", "   j x..x   ", "    j x..xxx", "     j xx...", "      j  xxx", "       jj   ", "         jjj", "            ", "            ", "            "};
    private static final String[] left2down = new String[]{"            ", "            ", "jj          ", "  jj        ", "xx  j       ", "..xx j      ", "xx..x j     ", "  x..x j    ", "jj x.x j    ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   "};
    private static final String[] left2up = new String[]{"  j x.x j   ", "  j x.x j   ", "jj x.x j    ", "  x..x j    ", "xx..x j     ", "..xx j      ", "xx  j       ", "  jj        ", "jj          ", "            ", "            ", "            "};
    private static final String[] stubSource = new String[]{"    jjjjj   ", "   j     j  ", "jjj xxxxx j ", "   x.....x j", "xxxx.....x j", ".........x j", "xxxx.....x j", "   x.....x j", "jjj xxxxx j ", "   j     j  ", "    jjjjj   ", "            "};
    private static final String[] stubTarget = new String[]{"   jjjjj    ", "  j     j   ", " j xxxxx jjj", "j x.....x   ", "j x.....xxxx", "j x.........", "j x.....xxxx", "j x.....x   ", " j xxxxx jjj", "  j     j   ", "   jjjjj    ", "            "};
    private static final String[] hd = new String[]{"            ", "            ", "  jjjjjjjj  ", "            ", "  xxxxxxxx  ", "  ........  ", "  xxxxxxxx  ", "            ", "  jjjjjjjj  ", "            ", "            ", "            "};
    private static final String[] vd = new String[]{"            ", "            ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "  j x.x j   ", "            ", "            "};
    private static final String[] stubSourceDashed = new String[]{"    jjjjj   ", "   j     j  ", "jjj xxxxx j ", "   x.. ..x j", "xxxx.   .x j", "....    .x j", "xxxx.   .x j", "   x.. ..x j", "jjj xxxxx j ", "   j     j  ", "    jjjjj   ", "            "};
    private static final String[] stubTargetDashed = new String[]{"   jjjjj    ", "  j     j   ", " j xxxxx jjj", "j x.. ..x   ", "j x.   .xxxx", "j x.    ....", "j x.   .xxxx", "j x.. ..x   ", " j xxxxx jjj", "  j     j   ", "   jjjjj    ", "            "};
    private static Wimages tiles;
    private static Wimages dashedTiles;
    private static Wimages greenTiles;
    private static Wimages blueTiles;
    private static Wimages selectedTiles;
    private static final ImageDecoder stdImageDecoder;
    private static final ImageDecoder highlightImageDecoder;
    private static final Map<Integer, Wimages> hlWimagesMap;
    private static final BColor[] hlColors;

    public static Wimages get(int linkColorCode, int linkHighlightColorCode, boolean selected) {
        if (tiles == null) {
            TileImages.loadDefaults();
        }
        Wimages wimgs = selected ? selectedTiles : (linkColorCode == 1 ? greenTiles : (linkColorCode == 2 ? dashedTiles : tiles));
        if (linkHighlightColorCode > -1) {
            wimgs = new CompositeWimages(TileImages.getHighlightWimages(linkHighlightColorCode), wimgs);
        }
        return wimgs;
    }

    private static void loadDefaults() {
        tiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)64, (int)64, (int)64), BColor.make((int)128, (int)128, (int)128));
        dashedTiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)0, (int)64, (int)64), BColor.make((int)0, (int)128, (int)128), true);
        greenTiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)0, (int)128, (int)0), BColor.make((int)0, (int)200, (int)0));
        blueTiles = TileImages.makeWimages(stdImageDecoder, BColor.make((int)0, (int)64, (int)64), BColor.make((int)0, (int)128, (int)128));
        selectedTiles = tiles.makeHighlighted();
    }

    private static Wimages getHighlightWimages(int linkHighlightColorCode) {
        Integer index;
        Wimages wimages;
        if (linkHighlightColorCode >= hlColors.length) {
            linkHighlightColorCode %= hlColors.length;
        }
        if ((wimages = hlWimagesMap.get(index = new Integer(linkHighlightColorCode))) == null) {
            wimages = TileImages.makeWimages(highlightImageDecoder, hlColors[linkHighlightColorCode]);
            hlWimagesMap.put(index, wimages);
        }
        return wimages;
    }

    private static Wimages makeWimages(ImageDecoder imgDecoder, BColor col) {
        return TileImages.makeWimages(imgDecoder, col, BColor.white);
    }

    private static Wimages makeWimages(ImageDecoder imgDecoder, BColor col1, BColor col2) {
        return TileImages.makeWimages(imgDecoder, col1, col2, false);
    }

    private static Wimages makeWimages(ImageDecoder imgDecoder, BColor col1, BColor col2, boolean dashed) {
        BImage[] tiles = new BImage[11];
        if (dashed) {
            tiles[1] = imgDecoder.make(hd, col1, col2);
            tiles[2] = imgDecoder.make(vd, col1, col2);
            tiles[3] = imgDecoder.make(stubTargetDashed, col1, col2);
            tiles[4] = imgDecoder.make(stubSourceDashed, col1, col2);
        } else {
            tiles[1] = imgDecoder.make(h, col1, col2);
            tiles[2] = imgDecoder.make(v, col1, col2);
            tiles[3] = imgDecoder.make(stubTarget, col1, col2);
            tiles[4] = imgDecoder.make(stubSource, col1, col2);
        }
        tiles[5] = imgDecoder.make(hCross, col1, col2);
        tiles[6] = imgDecoder.make(vCross, col1, col2);
        tiles[7] = imgDecoder.make(left2up, col1, col2);
        tiles[8] = imgDecoder.make(left2down, col1, col2);
        tiles[9] = imgDecoder.make(right2up, col1, col2);
        tiles[10] = imgDecoder.make(right2down, col1, col2);
        return new StdWimages(tiles);
    }

    private static BColor loadColor(int index, BColor defaultColor) {
        return BColor.make((String)AccessController.doPrivileged(() -> System.getProperty("niagara.wiresheet.linkHighlightColor" + index, defaultColor.toHtmlString())));
    }

    static {
        stdImageDecoder = new StdImageDecoder();
        highlightImageDecoder = new HighlightImageDecoder();
        hlWimagesMap = new HashMap<Integer, Wimages>();
        hlColors = new BColor[]{TileImages.loadColor(1, WsConst.selectionFg), TileImages.loadColor(2, BColor.green), TileImages.loadColor(3, BColor.purple), TileImages.loadColor(4, BColor.orange), TileImages.loadColor(5, BColor.blue), TileImages.loadColor(6, BColor.brown), TileImages.loadColor(7, BColor.magenta), TileImages.loadColor(8, BColor.midnightBlue), TileImages.loadColor(9, BColor.darkGreen), TileImages.loadColor(10, BColor.darkOrange), TileImages.loadColor(11, BColor.darkGoldenrod), TileImages.loadColor(12, BColor.indigo), TileImages.loadColor(13, BColor.cadetBlue), TileImages.loadColor(14, BColor.grey), TileImages.loadColor(15, BColor.peru), TileImages.loadColor(16, BColor.darkKhaki), TileImages.loadColor(17, BColor.firebrick), TileImages.loadColor(18, BColor.black), TileImages.loadColor(19, BColor.hotPink), TileImages.loadColor(20, BColor.slateBlue)};
    }

    private static final class CompositeWimages
    extends Wimages {
        private Wimages wimgs1;
        private Wimages wimgs2;

        private CompositeWimages(Wimages wimgs1, Wimages wimgs2) {
            this.wimgs1 = wimgs1;
            this.wimgs2 = wimgs2;
        }

        @Override
        public void paint(Graphics g, int wixel, int tileIndex, double x, double y) {
            this.wimgs1.paint(g, wixel, tileIndex, x, y);
            this.wimgs2.paint(g, wixel, tileIndex, x, y);
        }

        @Override
        protected Wimages makeHighlighted() {
            return new CompositeWimages(this.wimgs1, this.wimgs2.makeHighlighted());
        }
    }

    private static final class StdWimages
    extends Wimages {
        private BImage[] imgs;

        private StdWimages(BImage[] imgs) {
            this.imgs = imgs;
        }

        @Override
        public void paint(Graphics g, int wixel, int tileIndex, double x, double y) {
            BImage link = this.imgs[tileIndex].transform(BTransform.makeScale((double)((double)wixel / 12.0), (double)((double)wixel / 12.0)));
            g.drawImage(link, x, y);
        }

        @Override
        protected Wimages makeHighlighted() {
            BImage[] newImgs = new BImage[this.imgs.length];
            for (int i = 1; i < newImgs.length; ++i) {
                newImgs[i] = this.imgs[i].getHighlightedImage();
            }
            return new StdWimages(newImgs);
        }
    }

    public static abstract class Wimages {
        protected Wimages() {
        }

        public abstract void paint(Graphics var1, int var2, int var3, double var4, double var6);

        protected abstract Wimages makeHighlighted();
    }

    private static class HighlightImageDecoder
    extends ImageDecoder {
        private HighlightImageDecoder() {
        }

        @Override
        BImage make(String[] pattern, BColor col1, BColor col2) {
            BImage tile = BImage.make((double)12.0, (double)12.0);
            Graphics g = tile.getGraphics();
            g.setBrush(col1);
            for (int x = 0; x < 12; ++x) {
                for (int y = 0; y < 12; ++y) {
                    char c = pattern[y].charAt(x);
                    if (c != 'j') continue;
                    g.strokeLine((double)x, (double)y, (double)x, (double)y);
                }
            }
            g.dispose();
            return tile;
        }
    }

    private static class StdImageDecoder
    extends ImageDecoder {
        private StdImageDecoder() {
        }

        @Override
        BImage make(String[] pattern, BColor col1, BColor col2) {
            BImage tile = BImage.make((double)12.0, (double)12.0);
            Graphics g = tile.getGraphics();
            for (int x = 0; x < 12; ++x) {
                for (int y = 0; y < 12; ++y) {
                    char c = pattern[y].charAt(x);
                    if (c == ' ' || c == 'j') continue;
                    BColor col = c == 'x' ? col1 : col2;
                    g.setBrush(col);
                    g.strokeLine((double)x, (double)y, (double)x, (double)y);
                }
            }
            g.dispose();
            return tile;
        }
    }

    private static abstract class ImageDecoder {
        private ImageDecoder() {
        }

        abstract BImage make(String[] var1, BColor var2, BColor var3);
    }
}

