/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.sys.engine.NKnob;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LayerGlyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import java.util.Comparator;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Knob;

public class LinkLayerGlyph
extends LayerGlyph {
    LinkLayerGlyph(BWireSheetPane ws) {
        super(ws);
    }

    @Override
    public void selectAllInPixelRect(RectGeom r) {
        Glyph[] kids = this.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            LinkGlyph kid = (LinkGlyph)kids[i];
            if (!kid.isSelectable() || !kid.inside(r)) continue;
            this.ws.selection.select(kid);
        }
    }

    public void removeKnobGlyph(Knob knob) {
        int id = ((NKnob)knob).id;
        Glyph[] kids = this.getChildGlyphs();
        for (int i = 0; i < kids.length; ++i) {
            if (!(kids[i] instanceof LinkKnobGlyph)) continue;
            LinkKnobGlyph glyph = (LinkKnobGlyph)kids[i];
            if (glyph.knob.id != id) continue;
            this.remove(glyph);
            break;
        }
    }

    @Override
    public void paint(Graphics g) {
        Glyph[] children = this.getChildGlyphs();
        for (int i = children.length - 1; i >= 0; --i) {
            Glyph child = children[i];
            if (!child.visible) continue;
            child.paint(g);
        }
    }

    LinkGlyph[] getLinkGlyphsAt(int p, int q) {
        Array linkArray = new Array(LinkGlyph.class);
        Glyph[] glyphs = this.getChildGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            if (!(glyphs[i] instanceof LinkGlyph) || !glyphs[i].visible || !glyphs[i].contains(p, q)) continue;
            linkArray.add((Object)((LinkGlyph)glyphs[i]));
        }
        linkArray = linkArray.sort((Comparator)new Comparator<LinkGlyph>(){

            @Override
            public int compare(LinkGlyph arg0, LinkGlyph arg1) {
                LinkGlyph g1 = arg0;
                LinkGlyph g2 = arg1;
                return SortUtil.compare((Object)g1.getStatusMessage(), (Object)g2.getStatusMessage());
            }
        });
        return (LinkGlyph[])linkArray.trim();
    }

    void selectLink(String sourceHandle, String sourceSlotName, String targetHandle, String targetSlotName) {
        Glyph[] glyphs = this.getChildGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            LinkGlyph lGlyph;
            if (!glyphs[i].visible || !(glyphs[i] instanceof LinkGlyph) || !(lGlyph = (LinkGlyph)glyphs[i]).getGotoLinkSourceHandle().equals(sourceHandle) || !lGlyph.getGotoLinkSourceSlotName().equals(sourceSlotName) || !lGlyph.getGotoLinkTargetHandle().equals(targetHandle) || !lGlyph.getGotoLinkTargetSlotName().equals(targetSlotName)) continue;
            this.ws.selection.select(lGlyph);
            RectGeom rg = new RectGeom((double)(lGlyph.getMinP() * this.ws.grid.wixel), (double)(lGlyph.getMinQ() * this.ws.grid.wixel), this.ws.getWidth() / 2.0, this.ws.getHeight() / 2.0);
            this.ws.getScrollPane().scrollToVisible(rg);
            break;
        }
    }
}

