/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.sys.engine.NKnob;
import com.tridium.util.LinkUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.commands.DeleteLinksCommand;
import java.security.AccessController;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.Knob;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public class LinkKnobGlyph
extends LinkGlyph {
    NKnob knob;
    StdComponentGlyph sourceComp;
    SlotBarGlyph sourceSlot;
    boolean isComposite;
    BLink link;
    private static final boolean LEASE_FOR_KNOB_COLORS = AccessController.doPrivileged(() -> System.getProperty("niagara.wiresheet.leaseForOutgoingStubColors", "false")).equals("true");

    protected LinkKnobGlyph(BWireSheetPane ws, Knob knob, StdComponentGlyph sourceComp) {
        super(ws, "Knob:" + sourceComp.handle + "." + ((NKnob)knob).id);
        this.knob = (NKnob)knob;
        this.sourceComp = sourceComp;
        this.sourceSlot = sourceComp.getVisibleSlotBar(knob.getSourceSlotName());
        this.isComposite = false;
    }

    @Override
    public StdComponentGlyph getSourceComponentGlyph() {
        return this.sourceComp;
    }

    @Override
    public StdComponentGlyph getTargetComponentGlyph() {
        return null;
    }

    @Override
    public SlotBarGlyph getSourceSlotGlyph() {
        return this.sourceSlot;
    }

    @Override
    public SlotBarGlyph getTargetSlotGlyph() {
        return null;
    }

    @Override
    public String getStatusMessage() {
        return LinkUtil.toDisplay((Knob)this.knob) + (this.isComposite ? " (C)" : "");
    }

    @Override
    public int getLinkColorCode() {
        return LEASE_FOR_KNOB_COLORS ? BWsOptions.make().toLinkColorCode(this.getLink()) : BWsOptions.make().toLinkColorCode((Knob)this.knob);
    }

    @Override
    public void mouseEntered() {
        this.isComposite = LinkUtil.isCompositeLink((BLink)this.getLink());
        super.mouseEntered();
    }

    @Override
    BOrd getGotoOrd() {
        return this.knob.getTargetOrd();
    }

    @Override
    public void popup(double mx, double my) {
        BMenu menu = new BMenu();
        menu.add(null, (Command)new LinkGlyph.GotoLinkCommand(this));
        menu.add(null, (Command)new LinkGlyph.GotoCommand(this));
        if (!this.isComposite) {
            menu.add(null, (Command)new DeleteLinksCommand(this.ws));
        }
        int p = (int)(mx / (double)this.ws.grid.wixel);
        int q = (int)(my / (double)this.ws.grid.wixel);
        this.ws.controller.addLinkSelection(menu, p, q);
        menu.open((BWidget)this.ws.getCanvas(), mx, my);
    }

    @Override
    protected String getGotoLinkSourceHandle() {
        return this.getHandleFromOrd(this.knob.getSourceOrd());
    }

    @Override
    protected String getGotoLinkSourceSlotName() {
        return this.knob.getSourceSlotName();
    }

    @Override
    protected String getGotoLinkTargetHandle() {
        return this.getHandleFromOrd(this.knob.getTargetOrd());
    }

    @Override
    protected String getGotoLinkTargetSlotName() {
        return this.knob.getTargetSlotName();
    }

    @Override
    public void doubleClicked(BMouseEvent event) {
        new LinkGlyph.GotoLinkCommand(this).invoke(new CommandEvent((BInputEvent)event));
    }

    @Override
    public void findLinks(WsPrinting p) {
        this.linkName = p.addKnobLink(LinkUtil.toDisplaySource((Knob)this.knob), LinkUtil.toDisplayTarget((Knob)this.knob));
    }

    @Override
    public LinkGlyph.Tile[] buildTiles() {
        if (this.sourceSlot == null) {
            System.out.println("ERROR: LinkKnobGlyph.noSourceSlot: " + this.knob);
            return new LinkGlyph.Tile[0];
        }
        int p = this.sourceSlot.absP() + this.sourceSlot.ww;
        int q = this.sourceSlot.absQ();
        return new LinkGlyph.Tile[]{new LinkGlyph.Tile(p, q, 4, this.ws)};
    }

    public synchronized BLink getLink() {
        if (this.link != null) {
            return this.link;
        }
        BComponent targetComp = (BComponent)this.knob.getTargetOrd().get((BObject)this.sourceComp.component);
        targetComp.lease();
        BLink[] links = targetComp.getLinks();
        for (int i = 0; i < links.length; ++i) {
            if (!links[i].getTargetSlotName().equals(this.knob.getTargetSlotName()) || !links[i].getSourceOrd().equals((Object)this.knob.getSourceOrd()) || !links[i].getSourceSlotName().equals(this.knob.getSourceSlotName())) continue;
            this.link = links[i];
            return this.link;
        }
        return null;
    }
}

