/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.wiresheet.pdf.BPdfWsCanvas;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.baja.gx.BSize;
import javax.baja.gx.Insets;
import javax.baja.nre.util.TextUtil;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.wiresheet.BWireSheet;
import javax.baja.workbench.view.BIWbViewExporter;

public class BWireSheetToPdf
extends BPdfExporter
implements BIWbViewExporter {
    public static final Property showTitleBlock = BWireSheetToPdf.newProperty((int)0, (boolean)true, null);
    public static final Property showPropertyValues = BWireSheetToPdf.newProperty((int)0, (boolean)false, null);
    public static final Property showOffscreenLinks = BWireSheetToPdf.newProperty((int)0, (boolean)true, null);
    public static final Property info = BWireSheetToPdf.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    public static final Type TYPE = Sys.loadType(BWireSheetToPdf.class);

    public boolean getShowTitleBlock() {
        return this.getBoolean(showTitleBlock);
    }

    public void setShowTitleBlock(boolean v) {
        this.setBoolean(showTitleBlock, v, null);
    }

    public boolean getShowPropertyValues() {
        return this.getBoolean(showPropertyValues);
    }

    public void setShowPropertyValues(boolean v) {
        this.setBoolean(showPropertyValues, v, null);
    }

    public boolean getShowOffscreenLinks() {
        return this.getBoolean(showOffscreenLinks);
    }

    public void setShowOffscreenLinks(boolean v) {
        this.setBoolean(showOffscreenLinks, v, null);
    }

    public String getInfo() {
        return this.getString(info);
    }

    public void setInfo(String v) {
        this.setString(info, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWireSheetToPdf() {
        this.setPageSize(BSize.make((double)11.0, (double)8.5));
    }

    public void export(PdfOp op) throws Exception {
        BWireSheet wireSheet = (BWireSheet)op.get();
        BWireSheetPane ws = BWireSheetPane.get((BWidget)wireSheet);
        PdfDocument doc = new PdfDocument(op.getOutputStream(), op.getWidth(), op.getHeight());
        String path = ws.controller.container.getSlotPath().toString();
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy");
        String date = format.format(new Date());
        Insets m = doc.getMargins();
        double w = doc.getPageSize().width - (m.left + m.right);
        double h = doc.getPageSize().height - (m.top + m.bottom);
        WsPrinting wsp = new WsPrinting();
        wsp.showTitleBox = this.getShowTitleBlock();
        wsp.paintValues = this.getShowPropertyValues();
        wsp.paintLinks = this.getShowOffscreenLinks();
        ws.getCanvas().getRootGlyph().findLinks(wsp);
        BPdfWsCanvas canvas = new BPdfWsCanvas(ws, wsp, w, h);
        canvas.getTitleBox().addLine(path);
        canvas.getTitleBox().addLine(date);
        String info = this.getInfo();
        if (info.length() > 0) {
            String[] s = TextUtil.split((String)info, (char)'\n');
            for (int i = 0; i < s.length; ++i) {
                canvas.getTitleBox().addLine(s[i]);
            }
        }
        BPdfFlowPane flow = new BPdfFlowPane();
        flow.add(null, (BValue)canvas);
        if (this.getShowOffscreenLinks() && !wsp.getLinks().isEmpty()) {
            flow.add(null, (BValue)new BTable((TableModel)new Model(wsp.getLinks())));
        }
        flow.setupPane();
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument((BWidget)flow, doc, op);
    }

    private class Model
    extends TableModel {
        private ArrayList<WsPrinting.Link> links;
        private String[] cols = new String[]{"Link", "Source", "Target"};

        public Model(ArrayList<WsPrinting.Link> links) {
            this.links = links;
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }

        public int getRowCount() {
            return this.links.size();
        }

        public Object getValueAt(int row, int col) {
            WsPrinting.Link link = this.links.get(row);
            switch (col) {
                case 0: {
                    return link.name;
                }
                case 1: {
                    return link.source;
                }
                case 2: {
                    return link.target;
                }
            }
            return "";
        }
    }
}

