/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp.servlet;

import com.tridium.authn.LoginFailureCause;
import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.SAMLResponseException;
import com.tridium.saml.attributes.BSAMLAttributeMapping;
import com.tridium.saml.attributes.BSAMLUserProperty;
import com.tridium.saml.attributes.BSAMLUserPropertyType;
import com.tridium.saml.authnScheme.BSAMLAuthenticationScheme;
import com.tridium.saml.rp.Response;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfo;
import com.tridium.saml.rp.servlet.SAMLAuthenticationInfoHandler;
import com.tridium.saml.utils.SAMLUtils;
import com.tridium.util.EscUtil;
import com.tridium.web.CookieUtil;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototype;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.servlets.UnauthenticatedServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLConsumerServlet
extends UnauthenticatedServlet {
    private static final String SAML_RESPONSE_NAME = "SAMLResponse";
    private static final Set<Integer> types = Collections.unmodifiableSet(Arrays.stream(BSAMLUserPropertyType.DEFAULT.getRange().getOrdinals()).boxed().collect(Collectors.toSet()));

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String rawSAMLResponse = this.getSAMLResponseFromParameter(request);
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "rawSAMLResponse:\n" + rawSAMLResponse);
            }
            String samlXMLResponse = SAMLUtils.processRawSAMLMessage(rawSAMLResponse, false, false);
            if (SAMLUtils.isLoggable(Level.FINEST)) {
                SAMLUtils.log(Level.FINEST, "samlXMLResponse:\n" + samlXMLResponse);
            }
            this.processSAMLResponse(request, response, samlXMLResponse);
            response.sendRedirect("/j_security_check");
        }
        catch (SAMLException e) {
            SAMLUtils.log(Level.WARNING, e.getMessage(), e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_info", (String)Base64.getEncoder().encodeToString(String.format("SAML login failed (%s)", e.getGenericErrorMessage()).getBytes(StandardCharsets.UTF_8)), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
        catch (Throwable t) {
            SAMLUtils.log(Level.WARNING, t.getMessage(), t);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String rawSAMLResponse = this.getSAMLResponseFromQuery(request);
            String samlXMLResponse = SAMLUtils.processRawSAMLMessage(rawSAMLResponse, true, true);
            this.processSAMLResponse(request, response, samlXMLResponse);
            response.sendRedirect("/j_security_check");
        }
        catch (SAMLException e) {
            SAMLUtils.log(Level.WARNING, e.getMessage(), e);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_info", (String)Base64.getEncoder().encodeToString(String.format("SAML login failed (%s)", e.getGenericErrorMessage()).getBytes(StandardCharsets.UTF_8)), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
        catch (Throwable t) {
            SAMLUtils.log(Level.WARNING, t.getMessage(), t);
            response.addCookie(CookieUtil.createCookie((String)"niagara_failure_cause", (String)LoginFailureCause.SSO_FAILURE.name(), (int)-1));
            response.sendRedirect("/login?auth=fail");
        }
    }

    private String getSAMLResponseFromParameter(HttpServletRequest request) throws SAMLException {
        String parameter = request.getParameter(SAML_RESPONSE_NAME);
        if (parameter == null) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noResponseInParam"));
        }
        return parameter;
    }

    private String getSAMLResponseFromQuery(HttpServletRequest request) throws SAMLException {
        String[] queries;
        String query = request.getQueryString();
        if (query == null) {
            throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noResponseInQuery"));
        }
        for (String queryItem : queries = query.split("&")) {
            String[] queryPieces = queryItem.split("=");
            if (!SAML_RESPONSE_NAME.equals(queryPieces[0])) continue;
            return queryPieces[1];
        }
        throw new SAMLResponseException(Lexicon.make((String)"saml").get("saml.exception.noResponseInQuery"));
    }

    private void processSAMLResponse(HttpServletRequest request, HttpServletResponse response, String samlXMLResponse) throws SAMLException, IllegalStateException {
        Response samlResponse = new Response(request, samlXMLResponse);
        BSAMLAuthenticationScheme ssoScheme = samlResponse.getSsoScheme();
        response.addCookie(CookieUtil.createCookie((String)"niagara_current_sso_scheme", (String)ssoScheme.getName(), (int)-1));
        samlResponse.checkValidity(null);
        String username = this.prepareUser(ssoScheme, samlResponse);
        NiagaraWebSession session = WebSessionUtil.getSession((HttpServletRequest)request, (boolean)true);
        SAMLAuthenticationInfo authenticationInfo = new SAMLAuthenticationInfo(username);
        AccessController.doPrivileged(() -> {
            SAMLAuthenticationInfoHandler.addAuthenticationInfo(session, authenticationInfo);
            return null;
        });
    }

    private String prepareUser(BSAMLAuthenticationScheme samlScheme, Response samlResponse) throws SAMLException {
        Map<String, List<String>> rawUserAttributes = samlResponse.getUserAttributes();
        Map<String, BValue> userAttributes = this.prepareAttributes(rawUserAttributes, samlScheme);
        String username = userAttributes.getOrDefault("username", (BValue)BString.make((String)samlResponse.getNameId())).toString();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser user = userService.getUser(username);
        boolean addUser = false;
        if (user == null) {
            user = new BUser();
            addUser = true;
        }
        user.setAuthenticator(samlScheme.getDefaultAuthenticator());
        BUserPrototypes userPrototypes = userService.getUserPrototypes();
        BString prototypeName = (BString)userAttributes.get("prototypeName");
        BValue proto = userPrototypes.get(SlotPath.escape((String)prototypeName.getString()));
        if (!(proto instanceof BUserPrototype)) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").get("saml.exception.badPrototype"));
        }
        BUserPrototype prototype = (BUserPrototype)proto;
        if (addUser) {
            userService.add(EscUtil.slot.escape(username), (BValue)user);
        }
        prototype.updateUserFromPrototype(user, userAttributes, !prototypeName.getString().equals(user.getPrototypeName()));
        user.setFlags((Slot)BUser.authenticationSchemeName, user.getFlags((Slot)BUser.authenticationSchemeName) | 1);
        user.setFlags((Slot)BUser.prototypeName, user.getFlags((Slot)BUser.prototypeName) | 1);
        return username;
    }

    private Map<String, BValue> prepareAttributes(Map<String, List<String>> rawUserAttributes, BSAMLAuthenticationScheme samlScheme) {
        HashMap<String, BValue> userAttributes = new HashMap<String, BValue>();
        HashSet<Integer> propertyTypes = new HashSet<Integer>(types);
        Set<BSAMLAttributeMapping> mappings = samlScheme.getAttributeMappings();
        for (BSAMLAttributeMapping mapping : mappings) {
            BSAMLUserProperty userProperty = mapping.getUserProperty();
            BSAMLUserPropertyType mappingType = userProperty.getUserPropertyType();
            int mappingTypeOrdinal = mappingType.getOrdinal();
            if (!types.contains(mappingTypeOrdinal)) {
                SAMLUtils.log.log(Level.FINE, Lexicon.make((String)"saml").getText("saml.exception.duplicateAttribute", new Object[]{mappingType.getTag(), mapping.getSAMLAttributeName()}));
                continue;
            }
            List<String> attributeValues = rawUserAttributes.get(mapping.getSAMLAttributeName());
            if (attributeValues == null) continue;
            try {
                userAttributes.put(mappingType.getTag(), userProperty.makeBValueFromAttribute(attributeValues));
                SAMLUtils.log(Level.FINER, () -> String.format("Processed Niagara attribute <%s> with value <%s>", mappingType.getTag(), userAttributes.get(mappingType.getTag())));
                propertyTypes.remove(mappingTypeOrdinal);
            }
            catch (SAMLException e) {
                SAMLUtils.log(Level.FINE, Lexicon.make((String)"saml").getText("saml.exception.cannotParseAttribute", new Object[]{mapping.getSAMLAttributeName()}), e);
            }
        }
        Iterator<BSAMLAttributeMapping> iterator = propertyTypes.iterator();
        while (iterator.hasNext()) {
            int typeOrdinal = (Integer)((Object)iterator.next());
            BSAMLUserPropertyType propertyType = BSAMLUserPropertyType.make(typeOrdinal);
            List<String> attributeValues = rawUserAttributes.get(propertyType.getTag());
            if (attributeValues == null) continue;
            try {
                BSAMLUserProperty property = BSAMLUserPropertyType.generateSAMLUserProperty(propertyType);
                userAttributes.put(propertyType.getTag(), property.makeBValueFromAttribute(attributeValues));
                SAMLUtils.log(Level.FINER, () -> String.format("Processed Niagara attribute <%s> with value <%s>", propertyType.getTag(), userAttributes.get(propertyType.getTag())));
            }
            catch (SAMLException e) {
                SAMLUtils.log(Level.FINE, Lexicon.make((String)"saml").getText("saml.exception.cannotParseAttribute", new Object[]{propertyType.getTag()}), e);
            }
        }
        if (userAttributes.get("prototypeName") == null) {
            userAttributes.put("prototypeName", (BValue)BString.make((String)BUserService.getService().getUserPrototypes().getAlternateDefaultPrototype()));
        }
        userAttributes.put("authenticationSchemeName", (BValue)BString.make((String)samlScheme.getName()));
        return userAttributes;
    }
}

