/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.rp;

import com.onelogin.saml.Utils;
import com.tridium.saml.SAMLAuthnRequestException;
import com.tridium.saml.SAMLException;
import com.tridium.security.SAMLPermission;
import java.io.ByteArrayOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.baja.util.Lexicon;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AuthnRequest {
    private UUID id;
    private String assertionConsumerServiceURL;
    private String issuerURL;
    private String issueInstant;
    private String destination;
    private String protocolBinding;
    private static final boolean useUnspecifiedAuthnContextClassRef = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.saml.authnContextClassRef.unspecified"));

    private AuthnRequest(String assertionConsumerServiceURL, String issuerURL, String destination) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
        this.issuerURL = issuerURL;
        this.destination = destination;
        this.id = UUID.randomUUID();
        this.issueInstant = ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT);
        this.protocolBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    }

    private AuthnRequest() {
    }

    public static AuthnRequest make(String assertionConsumerServiceURL, String issuerURL, String destination) {
        SAMLPermission samlPermission = new SAMLPermission("createAuthnRequest");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)samlPermission);
        }
        return new AuthnRequest(assertionConsumerServiceURL, issuerURL, destination);
    }

    public static AuthnRequest parseAuthnRequest(String authnRequestXml) throws SAMLException {
        SAMLPermission samlPermission = new SAMLPermission("createAuthnRequest");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)samlPermission);
        }
        AuthnRequest authnRequest = new AuthnRequest();
        Document authnRequestDoc = Utils.loadXML(authnRequestXml);
        if (authnRequestDoc == null) {
            throw new SAMLAuthnRequestException("Failed to build AuthnRequest document");
        }
        Element rootElement = authnRequestDoc.getDocumentElement();
        AuthnRequest.validateSchema(authnRequestDoc);
        AuthnRequest.validateType(authnRequestDoc);
        authnRequest.id = AuthnRequest.parseId(rootElement);
        AuthnRequest.validateVersion(rootElement);
        authnRequest.issueInstant = AuthnRequest.parseAttribute(rootElement, "IssueInstant");
        authnRequest.destination = AuthnRequest.parseAttribute(rootElement, "Destination");
        authnRequest.protocolBinding = AuthnRequest.parseAttribute(rootElement, "ProtocolBinding");
        authnRequest.assertionConsumerServiceURL = AuthnRequest.parseAttribute(rootElement, "AssertionConsumerServiceURL");
        authnRequest.issuerURL = AuthnRequest.parseIssuerURL(authnRequestDoc);
        return authnRequest;
    }

    private static void validateSchema(Document authnRequestDoc) throws SAMLAuthnRequestException {
        try {
            Utils.validateXML(authnRequestDoc, "saml-schema-protocol-2.0.xsd");
        }
        catch (Throwable t) {
            throw new SAMLAuthnRequestException(Lexicon.make((String)"saml").get("saml.exception.schema"), t);
        }
    }

    private static void validateType(Document authnRequestDoc) throws SAMLAuthnRequestException {
        NodeList authnRequestNode = authnRequestDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest");
        if (authnRequestNode.getLength() != 1) {
            throw new SAMLAuthnRequestException("Invalid number of AuthnRequest elements. Expected 1.");
        }
    }

    private static UUID parseId(Element rootElement) throws SAMLAuthnRequestException {
        String parsedId = rootElement.getAttribute("ID");
        if (parsedId.isEmpty() || !parsedId.startsWith("_")) {
            throw new SAMLAuthnRequestException("Missing ID attribute.");
        }
        try {
            return UUID.fromString(parsedId.substring(1));
        }
        catch (IllegalArgumentException e) {
            throw new SAMLAuthnRequestException("Invalid ID attribute");
        }
    }

    private static void validateVersion(Element rootElement) throws SAMLAuthnRequestException {
        String version = rootElement.getAttribute("Version");
        if (version.isEmpty() || !version.equals("2.0")) {
            throw new SAMLAuthnRequestException("Invalid or missing Version attribute.");
        }
    }

    private static String parseAttribute(Element rootElement, String attributeName) throws SAMLAuthnRequestException {
        String attribute = rootElement.getAttribute(attributeName);
        if (attribute.isEmpty()) {
            throw new SAMLAuthnRequestException("Missing " + attributeName + " attribute.");
        }
        return attribute;
    }

    private static String parseIssuerURL(Document authnRequestDoc) throws SAMLAuthnRequestException {
        NodeList issuerElement = authnRequestDoc.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
        if (issuerElement.getLength() != 1) {
            throw new SAMLAuthnRequestException("Invalid number of Issuer elements. Expected 1.");
        }
        return issuerElement.item(0).getTextContent();
    }

    public String getRequest() throws SAMLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(baos);
            writer.writeStartElement("samlp", "AuthnRequest", "urn:oasis:names:tc:SAML:2.0:protocol");
            writer.writeNamespace("samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
            writer.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            writer.writeAttribute("ID", "_" + this.id.toString());
            writer.writeAttribute("Version", "2.0");
            writer.writeAttribute("IssueInstant", this.issueInstant);
            writer.writeAttribute("Destination", this.destination);
            writer.writeAttribute("ProtocolBinding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            writer.writeAttribute("AssertionConsumerServiceURL", this.assertionConsumerServiceURL);
            writer.writeStartElement("saml", "Issuer", "urn:oasis:names:tc:SAML:2.0:assertion");
            writer.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            writer.writeCharacters(this.issuerURL);
            writer.writeEndElement();
            writer.writeStartElement("samlp", "NameIDPolicy", "urn:oasis:names:tc:SAML:2.0:protocol");
            writer.writeAttribute("Format", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            writer.writeAttribute("AllowCreate", "true");
            writer.writeEndElement();
            writer.writeStartElement("samlp", "RequestedAuthnContext", "urn:oasis:names:tc:SAML:2.0:protocol");
            writer.writeAttribute("Comparison", useUnspecifiedAuthnContextClassRef ? "better" : "exact");
            writer.writeStartElement("saml", "AuthnContextClassRef", "urn:oasis:names:tc:SAML:2.0:assertion");
            writer.writeNamespace("saml", "urn:oasis:names:tc:SAML:2.0:assertion");
            writer.writeCharacters(useUnspecifiedAuthnContextClassRef ? "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified" : "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.flush();
            String result = baos.toString();
            return result;
        }
        catch (XMLStreamException e) {
            Lexicon lex = Lexicon.make((String)"saml");
            throw new SAMLException(lex.get("saml.exception.getXMLrequest"));
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getIssuerURL() {
        return this.issuerURL;
    }

    public String getIssueInstant() {
        return this.issueInstant;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public String toString() {
        return "AuthnRequest{id=" + this.id + ", assertionConsumerServiceURL='" + this.assertionConsumerServiceURL + '\'' + ", issuerURL='" + this.issuerURL + '\'' + ", issueInstant='" + this.issueInstant + '\'' + ", destination='" + this.destination + '\'' + ", protocolBinding='" + this.protocolBinding + '\'' + '}';
    }
}

