/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.saml.idp.BStationServiceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"saml:SAMLIdPService"})})
public class BSamlIdpSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BSamlIdpSecurityDashboardProviderAgent.class);
    private BSAMLIdPService idPService;
    private SecurityDashboardItemBuilder builder;
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 1;
    private static final String SECTION_HEADER = "securityDashboard.samlIdp.sectionHeader";
    private static final String TLS_ENABLED_SUMMARY = "securityDashboard.samlIdp.tls.enabled.summary";
    private static final String TLS_DISABLED_SUMMARY = "securityDashboard.samlIdp.tls.disabled.summary";
    private static final String ALERT_SUMMARY = "securityDashboard.samlIdp.tls.disabled.noEncryption.summary";
    private static final String TLS_DESCRIPTION = "securityDashboard.samlIdp.tls.description";

    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.idPService = (BSAMLIdPService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.idPService.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        ArrayList<String> okServiceProviders = new ArrayList<String>();
        ArrayList<String> warningServiceProviders = new ArrayList<String>();
        ArrayList<String> alertServiceProviders = new ArrayList<String>();
        List<Object> circles = Arrays.asList(this.idPService.getCircleOfTrustFolder().getChildren(BCircleOfTrust.class));
        for (BCircleOfTrust bCircleOfTrust : circles) {
            List<Object> serviceProviders = Arrays.asList(bCircleOfTrust.getServiceProviders().getChildren(BStationServiceProvider.class));
            for (BStationServiceProvider bStationServiceProvider : serviceProviders) {
                boolean usesTls = bStationServiceProvider.getIssuerUrl().startsWith("https");
                if (usesTls) {
                    okServiceProviders.add(bCircleOfTrust.getName() + '/' + bStationServiceProvider.getName());
                    continue;
                }
                if (bStationServiceProvider.getUseEncryption()) {
                    warningServiceProviders.add(bCircleOfTrust.getName() + '/' + bStationServiceProvider.getName());
                    continue;
                }
                alertServiceProviders.add(bCircleOfTrust.getName() + '/' + bStationServiceProvider.getName());
            }
        }
        if (!okServiceProviders.isEmpty()) {
            items.add(this.builder.makeOk().withSummary(TLS_ENABLED_SUMMARY, new Object[]{String.join((CharSequence)",", okServiceProviders)}).withDescription(TLS_DESCRIPTION, new Object[0]));
        }
        if (!warningServiceProviders.isEmpty()) {
            items.add(this.builder.makeWarning().withSummary(TLS_DISABLED_SUMMARY, new Object[]{String.join((CharSequence)",", warningServiceProviders)}).withDescription(TLS_DESCRIPTION, new Object[0]));
        }
        if (!alertServiceProviders.isEmpty()) {
            items.add(this.builder.makeAlert().withSummary(ALERT_SUMMARY, new Object[]{String.join((CharSequence)",", alertServiceProviders)}).withDescription(TLS_DESCRIPTION, new Object[0]));
        }
        return items;
    }
}

