/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.authn.BAuthenticationService;
import com.tridium.json.JSONArray;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BCircleOfTrustFolder;
import com.tridium.saml.idp.BISamlXmlEncrypter;
import com.tridium.saml.idp.BSAMLCoTPrototypesMixIn;
import com.tridium.saml.idp.BStationServiceProvider;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="idpSigningCert", type="String", defaultValue="", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"workbench:CertificateAliasFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:CertificateAliasEditor\")")}), @NiagaraProperty(name="entityId", type="String", defaultValue="https://supervisor.domain.com:443/saml/"), @NiagaraProperty(name="timeSkew", type="BRelTime", defaultValue="BRelTime.makeMinutes(3)"), @NiagaraProperty(name="applyTimeSkewToResponse", type="boolean", defaultValue="false"), @NiagaraProperty(name="circleOfTrustFolder", type="BCircleOfTrustFolder", defaultValue="new BCircleOfTrustFolder()")})
@NiagaraActions(value={@NiagaraAction(name="buildStationServiceProvider", parameterType="baja:String", defaultValue="BString.DEFAULT", returnType="BStationServiceProvider"), @NiagaraAction(name="getStations", returnType="baja:String"), @NiagaraAction(name="getUsers", returnType="baja:String"), @NiagaraAction(name="getAuthSchemes", returnType="baja:String")})
public final class BSAMLIdPService
extends BAbstractService
implements BIRestrictedComponent {
    public static final Property idpSigningCert = BSAMLIdPService.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:CertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))));
    public static final Property entityId = BSAMLIdPService.newProperty((int)0, (String)"https://supervisor.domain.com:443/saml/", null);
    public static final Property timeSkew = BSAMLIdPService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)3), null);
    public static final Property applyTimeSkewToResponse = BSAMLIdPService.newProperty((int)0, (boolean)false, null);
    public static final Property circleOfTrustFolder = BSAMLIdPService.newProperty((int)0, (BValue)new BCircleOfTrustFolder(), null);
    public static final Action buildStationServiceProvider = BSAMLIdPService.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action getStations = BSAMLIdPService.newAction((int)0, null);
    public static final Action getUsers = BSAMLIdPService.newAction((int)0, null);
    public static final Action getAuthSchemes = BSAMLIdPService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BSAMLIdPService.class);
    private static final BIcon icon = BIcon.make((String)"module://saml/rc/samlIdp.png");
    private static final Type[] serviceTypes = new Type[]{TYPE};
    public static final Logger LOG = Logger.getLogger("saml");
    private static final String LICENSE_FEATURE = "samlDP";
    private static final Lexicon LEXICON = Lexicon.make((String)"saml");
    private static final String HTTP_REDIRECT_ENDPOINT = "idp/auth/httpredirect/cot/";
    private static final String AUTHENTICATION_SCHEME_SLOT_NAME = "authenticationSchemeName";
    static final Context ENDPOINT_UPDATE_CONTEXT = new BasicContext();
    private BUserService userService;
    private BNiagaraNetwork niagaraNetwork;
    private BAuthenticationService authenticationServiceService;
    private Subscriber userSubscriber;

    public String getIdpSigningCert() {
        return this.getString(idpSigningCert);
    }

    public void setIdpSigningCert(String v) {
        this.setString(idpSigningCert, v, null);
    }

    public String getEntityId() {
        return this.getString(entityId);
    }

    public void setEntityId(String v) {
        this.setString(entityId, v, null);
    }

    public BRelTime getTimeSkew() {
        return (BRelTime)this.get(timeSkew);
    }

    public void setTimeSkew(BRelTime v) {
        this.set(timeSkew, (BValue)v, null);
    }

    public boolean getApplyTimeSkewToResponse() {
        return this.getBoolean(applyTimeSkewToResponse);
    }

    public void setApplyTimeSkewToResponse(boolean v) {
        this.setBoolean(applyTimeSkewToResponse, v, null);
    }

    public BCircleOfTrustFolder getCircleOfTrustFolder() {
        return (BCircleOfTrustFolder)this.get(circleOfTrustFolder);
    }

    public void setCircleOfTrustFolder(BCircleOfTrustFolder v) {
        this.set(circleOfTrustFolder, (BValue)v, null);
    }

    public BStationServiceProvider buildStationServiceProvider(BString parameter) {
        return (BStationServiceProvider)this.invoke(buildStationServiceProvider, (BValue)parameter, null);
    }

    public BString getStations() {
        return (BString)this.invoke(getStations, null, null);
    }

    public BString getUsers() {
        return (BString)this.invoke(getUsers, null, null);
    }

    public BString getAuthSchemes() {
        return (BString)this.invoke(getAuthSchemes, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BStationServiceProvider doBuildStationServiceProvider(BString stationName, Context context) {
        return new BStationServiceProvider();
    }

    public BString doGetStations(Context context) {
        if (this.niagaraNetwork == null) {
            this.niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        JSONArray jsonArray = new JSONArray();
        BDevice[] devices = this.niagaraNetwork.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!(devices[i] instanceof BNiagaraStation)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", devices[i].getName());
            map.put("displayName", devices[i].getDisplayName(context));
            jsonArray.put(map);
        }
        return BString.make((String)jsonArray.toString());
    }

    public BString doGetUsers(Context context) {
        if (this.userService == null) {
            this.userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        JSONArray jsonArray = new JSONArray();
        for (BUser user : this.userService.getUsers()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("handleOrd", user.getHandleOrd().toString());
            map.put("name", user.getName());
            map.put("displayName", user.getUsername());
            jsonArray.put(map);
        }
        return BString.make((String)jsonArray.toString());
    }

    public BString doGetAuthSchemes(Context context) {
        if (this.authenticationServiceService == null) {
            this.authenticationServiceService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        }
        JSONArray jsonArray = new JSONArray();
        for (BAuthenticationScheme scheme : this.authenticationServiceService.getSupportedSchemes()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("handleOrd", scheme.getHandleOrd().toString());
            map.put("name", scheme.getName());
            map.put("displayName", scheme.getDisplayName(context));
            jsonArray.put(map);
        }
        return BString.make((String)jsonArray.toString());
    }

    public BIcon getIcon() {
        return icon;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.updateCircleOfTrustEndpoints();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (entityId.equals(property)) {
            this.updateCircleOfTrustEndpoints();
        }
    }

    void updateCircleOfTrustEndpoints() {
        BCircleOfTrust[] circlesOfTrust;
        for (BCircleOfTrust circleOfTrust : circlesOfTrust = (BCircleOfTrust[])this.getCircleOfTrustFolder().getChildren(BCircleOfTrust.class)) {
            circleOfTrust.setString(BCircleOfTrust.httpRedirectEndpoint, this.getEntityId() + HTTP_REDIRECT_ENDPOINT + circleOfTrust.getUniqueId(), ENDPOINT_UPDATE_CONTEXT);
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void started() throws Exception {
        super.started();
        this.getComponentSpace().enableMixIn(BSAMLCoTPrototypesMixIn.TYPE);
    }

    public void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BSAMLCoTPrototypesMixIn.TYPE);
        if (this.userSubscriber != null) {
            this.userSubscriber.unsubscribeAll();
        }
        super.serviceStopped();
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public Feature getLicenseFeature() {
        Feature feature = null;
        try {
            feature = Sys.getLicenseManager().getFeature("tridium", LICENSE_FEATURE);
            if (feature == null || feature.get("OnOff") == null) {
                this.configFatal(LEXICON.getText("saml.license.feature.invalid"));
            } else if (!"true".equals(feature.get("OnOff"))) {
                this.configFatal(LEXICON.getText("saml.license.feature.inactive"));
            } else if (feature.isExpired()) {
                this.configFatal(LEXICON.getText("saml.license.feature.expired"));
            }
        }
        catch (FeatureNotLicensedException | LicenseDatabaseException e) {
            this.configFatal(LEXICON.getText("saml.license.feature.missing"));
        }
        return feature;
    }

    BCircleOfTrust getCircleOfTrust(BUuid uuid) {
        BCircleOfTrust[] circles;
        for (BCircleOfTrust circle : circles = (BCircleOfTrust[])this.getCircleOfTrustFolder().getChildren(BCircleOfTrust.class)) {
            if (!circle.getUniqueId().equals((Object)uuid)) continue;
            return circle;
        }
        return null;
    }

    BISamlXmlEncrypter getEncrypter() {
        BISamlXmlEncrypter[] encrypters = (BISamlXmlEncrypter[])this.getChildren(BISamlXmlEncrypter.class);
        if (encrypters.length != 1) {
            return null;
        }
        return encrypters[0];
    }

    Subscriber getUserSubscriber() {
        if (this.userSubscriber == null) {
            this.userSubscriber = Subscriber.make(event -> {
                BSAMLCoTPrototypesMixIn samlCoTPrototypesMixIn;
                if (event.getSourceComponent() instanceof BUser && (samlCoTPrototypesMixIn = (BSAMLCoTPrototypesMixIn)event.getSourceComponent().getMixIn(BSAMLCoTPrototypesMixIn.TYPE)) != null && 0 == event.getId() && AUTHENTICATION_SCHEME_SLOT_NAME.equals(event.getSlot().getName())) {
                    for (BComponent circleOfTrust : this.getCircleOfTrustFolder().getChildComponents()) {
                        samlCoTPrototypesMixIn.updateConfigurationFor((BCircleOfTrust)circleOfTrust);
                    }
                }
            });
        }
        return this.userSubscriber;
    }
}

