/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.idp;

import com.tridium.saml.utils.SAMLUtils;
import java.util.logging.Level;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;

@NiagaraType
public class BPrototypesFolder
extends BFolder {
    public static final Type TYPE = Sys.loadType(BPrototypesFolder.class);
    private static Context RENAME_CONTEXT = new BasicContext();

    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child.getType() == BString.TYPE;
    }

    public void checkRename(Property property, String newName, Context context) {
        if (context != RENAME_CONTEXT) {
            throw new IllegalNameException("saml", "saml.cotPrototypes.rename", new Object[0]);
        }
    }

    public void changed(Property property, Context context) {
        BString prototype = (BString)this.get(property);
        this.rename(property, prototype.toString(), RENAME_CONTEXT);
        super.changed(property, context);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BNameMap) {
            throw new LocalizableRuntimeException("saml", "saml.cotPrototypes.changeDisplayName");
        }
    }

    public void started() throws Exception {
        Property[] prototypeProperties;
        for (Property prototypeProperty : prototypeProperties = this.getPropertiesArray()) {
            if (prototypeProperty.getName().equals(this.getString(prototypeProperty))) continue;
            SAMLUtils.log(Level.SEVERE, "Mismatch between prototype name and value for circle of trust <" + this.getParent().getName() + ">'s <" + prototypeProperty.getName() + "> prototype. Removing prototype.");
            this.remove(prototypeProperty);
        }
        super.started();
    }
}

