/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.attributes;

import com.tridium.saml.SAMLConfigurationException;
import com.tridium.saml.SAMLException;
import com.tridium.saml.attributes.BISAMLUserPropertyInfo;
import com.tridium.saml.attributes.BSAMLPrototypeInfo;
import com.tridium.saml.attributes.BSAMLUserProperty;
import com.tridium.saml.attributes.BSAMLUserPropertyType;
import com.tridium.saml.utils.SAMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

@NiagaraType
@NiagaraProperty(name="info", type="saml:SAMLPrototypeInfo", defaultValue="new BSAMLPrototypeInfo()")
public class BSAMLPrototypeUserProperty
extends BSAMLUserProperty {
    public static final Property info = BSAMLPrototypeUserProperty.newProperty((int)0, (BValue)new BSAMLPrototypeInfo(), null);
    public static final Type TYPE = Sys.loadType(BSAMLPrototypeUserProperty.class);

    public BSAMLPrototypeInfo getInfo() {
        return (BSAMLPrototypeInfo)this.get(info);
    }

    public void setInfo(BSAMLPrototypeInfo v) {
        this.set(info, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BSAMLUserPropertyType getUserPropertyType() {
        return BSAMLUserPropertyType.prototypeName;
    }

    @Override
    public void setUserPropertyType(BSAMLUserPropertyType v) {
    }

    @Override
    public Optional<BISAMLUserPropertyInfo> getAttributeInfo() {
        return Optional.of(this.getInfo());
    }

    @Override
    public void setAttributeInfo(BISAMLUserPropertyInfo info) {
        if (!(info instanceof BSAMLPrototypeInfo)) {
            throw new IllegalArgumentException("Argument 'info' must be of type BSAMLPrototypeInfo");
        }
        this.getInfo().setCnOnly(((BSAMLPrototypeInfo)info).getCnOnly());
    }

    @Override
    public BValue makeBValueFromAttribute(List<String> attributeValues) throws SAMLException {
        BUserService userService = BUserService.getService();
        if (userService == null) {
            throw new SAMLConfigurationException(Lexicon.make((String)"saml").getText("saml.prototype.userServiceRequired"));
        }
        BUserPrototypes userPrototypes = userService.getUserPrototypes();
        BComponent[] prototypes = userPrototypes.getPrototypes();
        if (this.getInfo().getCnOnly()) {
            ArrayList<String> parsedAttributeValues = new ArrayList<String>();
            for (String attributeValue : attributeValues) {
                parsedAttributeValues.addAll(this.retrieveCNsFromValue(attributeValue));
            }
            attributeValues = parsedAttributeValues;
        }
        if (SAMLUtils.log.isLoggable(Level.FINEST)) {
            for (String prototypeValue : attributeValues) {
                SAMLUtils.log(Level.FINEST, Lexicon.make((String)"saml").getText("saml.prototype.foundPrototypeValue", new Object[]{prototypeValue}));
            }
        }
        for (BComponent prototype : prototypes) {
            String prototypeName = SlotPath.unescape((String)prototype.getName());
            if (!attributeValues.contains(prototypeName)) continue;
            if (prototype.getType().is(BUser.TYPE)) {
                SAMLUtils.log(Level.FINE, Lexicon.make((String)"saml").getText("saml.prototype.needsUserPrototype", new Object[]{prototypeName}));
                continue;
            }
            return BString.make((String)prototypeName);
        }
        return BString.make((String)userPrototypes.getAlternateDefaultPrototype());
    }

    private Set<String> retrieveCNsFromValue(String attributeValue) {
        try {
            LdapName dn = new LdapName(attributeValue);
            HashSet<String> prototypeValues = new HashSet<String>();
            for (Rdn rdn : dn.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                prototypeValues.add((String)rdn.getValue());
            }
            return prototypeValues;
        }
        catch (InvalidNameException e) {
            SAMLUtils.log(Level.FINE, Lexicon.make((String)"saml").get("saml.prototype.notADN"));
            return Collections.singleton(attributeValue);
        }
    }
}

