/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.js;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.web.js.BJsBuild;

public final class JsInfo {
    private final BOrd js;
    private final String buildId;
    public static final String[] STRINGS = new String[0];
    private static final String invalidErr = "Invalid JavaScript ORD: ";
    private static final Pattern moduleIdPattern = Pattern.compile("^module://(.+)\\.[jJ][sS]$");

    private JsInfo(BOrd js, String buildId) {
        if (js == null) {
            throw new IllegalArgumentException("js required");
        }
        this.js = js;
        this.buildId = buildId;
    }

    public static JsInfo make(BOrd js, String buildId) {
        return new JsInfo(js, buildId);
    }

    public static JsInfo make(BOrd js, Type buildType) {
        if (buildType == null || buildType.isAbstract() || !buildType.is(BJsBuild.TYPE)) {
            throw new IllegalArgumentException("BJsBuild subtype required");
        }
        BJsBuild build = (BJsBuild)buildType.getInstance();
        return new JsInfo(js, build.getId());
    }

    public static JsInfo make(BOrd js) {
        return new JsInfo(js, null);
    }

    public BOrd getJs() {
        return this.js;
    }

    public String getJsId() {
        return this.js.isNull() ? "" : JsInfo.toRequireJsId(this.js);
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String[] getBuiltJsIds() {
        List<BJsBuild> builds = this.getBuilds();
        ArrayList<String> ids = new ArrayList<String>();
        for (BJsBuild build : builds) {
            for (BOrd ord : build.getBuiltFiles()) {
                ids.add(JsInfo.toRequireJsId(ord));
            }
        }
        return ids.toArray(STRINGS);
    }

    private List<BJsBuild> getBuilds() {
        ArrayList<BJsBuild> list = new ArrayList<BJsBuild>();
        Optional<BJsBuild> build = BJsBuild.forId(this.buildId);
        if (build.isPresent()) {
            JsInfo.addBuilds(list, build.get());
        }
        return list;
    }

    private static void addBuilds(List<BJsBuild> list, BJsBuild build) {
        if (!build.isWebDevEnabled()) {
            list.add(build);
        }
        for (BJsBuild dep : build.getDependentBuilds()) {
            JsInfo.addBuilds(list, dep);
        }
    }

    public boolean hasBuiltJs() {
        return !this.getBuilds().isEmpty();
    }

    public static String toRequireJsId(BOrd ord) {
        Matcher matcher = moduleIdPattern.matcher(ord.toString());
        if (!matcher.find()) {
            throw new BajaRuntimeException(invalidErr + ord);
        }
        String path = matcher.group(1);
        if (path == null) {
            throw new BajaRuntimeException(invalidErr + ord);
        }
        return "nmodule/" + path;
    }
}

