/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.filters;

import java.io.IOException;
import java.util.Arrays;
import javax.baja.session.CsrfException;
import javax.baja.util.Lexicon;
import javax.baja.web.CsrfUtil;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CsrfProtectedFilter
implements Filter {
    private static final String SESSION_ERROR = "Unauthorized - Niagara session is empty";
    private static final Lexicon WEBLEX = Lexicon.make((String)"web");
    private static final String ERROR_MESSAGE = WEBLEX.get("csrf.token.error");
    private String[] methods;

    public void init(FilterConfig filterConfig) throws ServletException {
        String m;
        if (filterConfig != null && (m = filterConfig.getInitParameter("httpMethod")) != null) {
            this.methods = m.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block8: {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (Arrays.asList(this.methods).contains(req.getMethod())) {
                try {
                    if (CsrfUtil.verifyCsrfToken(req)) {
                        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                        break block8;
                    }
                    req.getServletContext().log(SESSION_ERROR);
                    resp.sendError(403, ERROR_MESSAGE);
                }
                catch (CsrfException ex) {
                    req.getServletContext().log(ex.getMessage(), (Throwable)ex);
                    if (req.getServletPath().equals("/logout")) {
                        resp.sendRedirect("/logoutConfirm");
                        return;
                    }
                    resp.sendError(403, ex.getMessage());
                }
                catch (IOException ie) {
                    req.getServletContext().log("Problem decoding csrf token from request", (Throwable)ie);
                    resp.sendError(400, ERROR_MESSAGE);
                }
                catch (Exception e) {
                    req.getServletContext().log("Csrf filter error", (Throwable)e);
                    resp.sendError(400, ERROR_MESSAGE);
                }
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    public void destroy() {
    }
}

