/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.authn;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class AuthMessage {
    public static final String ILLEGAL_TOKEN_CHARS = "(),/:;<=>?@[\\]{}";
    public static final String HELLO = "HELLO";
    public static final String HANDSHAKE_TOKEN = "handshakeToken";
    public static final String USERNAME = "username";
    public static final String BEARER = "BEARER";
    public static final String AUTH_TOKEN = "authToken";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTHENTICATION_INFO = "Authentication-Info";
    private String scheme;
    private Map<CaseInsensitiveStringKey, String> parameters = new LinkedHashMap<CaseInsensitiveStringKey, String>();

    public static AuthMessage decodeFromString(String message) {
        AuthMessage auth = new AuthMessage();
        int space = message.indexOf(" ");
        if (space >= 0) {
            auth.setScheme(message.substring(0, space));
            String params = message.substring(space + 1);
            StringTokenizer tokenizer = new StringTokenizer(params, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                int equal = token.indexOf("=");
                if (equal <= -1) {
                    throw new IllegalArgumentException("parameter missing '='");
                }
                String key = token.substring(0, equal).trim();
                String value = token.substring(equal + 1).trim();
                if (auth.getParameter(key) != null) {
                    throw new IllegalArgumentException("duplicate parameter");
                }
                auth.setParameter(key, value);
            }
        } else {
            auth.setScheme(message);
        }
        return auth;
    }

    public String encodeToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.scheme);
        boolean firstEntry = true;
        for (Map.Entry<CaseInsensitiveStringKey, String> entry : this.parameters.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
                builder.append(" ");
            } else {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public void setParameter(String key, String value) {
        if (!AuthMessage.isValidToken(key)) {
            throw new IllegalArgumentException("Parameter key is not a valid token");
        }
        if (!AuthMessage.isValidToken(value)) {
            throw new IllegalArgumentException("Parameter value is not a valid token");
        }
        this.parameters.put(new CaseInsensitiveStringKey(key), value);
    }

    public String getParameter(String key) {
        return this.parameters.get(new CaseInsensitiveStringKey(key));
    }

    public void setScheme(String scheme) {
        if (!AuthMessage.isValidToken(scheme)) {
            throw new IllegalArgumentException("Method is not a valid token");
        }
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    protected static boolean isValidToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c >= '!' && c <= '\u007f' && ILLEGAL_TOKEN_CHARS.indexOf(c) <= -1) continue;
            return false;
        }
        return true;
    }

    protected class CaseInsensitiveStringKey {
        final String key;

        CaseInsensitiveStringKey(String key) {
            Objects.requireNonNull(key);
            this.key = key;
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof CaseInsensitiveStringKey) {
                return this.key.equalsIgnoreCase(((CaseInsensitiveStringKey)anObject).getKey());
            }
            return false;
        }

        public int hashCode() {
            return this.key.toLowerCase().hashCode();
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

